/*
 * Decompiled with CFR 0.152.
 */
package br.com.damsete.arq.types;

import br.com.damsete.arq.types.Type;
import br.com.damsete.arq.utils.DigitGenerator;
import br.com.damsete.arq.utils.Digits;
import org.apache.commons.lang3.StringUtils;

public class Cpf
implements Type<Long> {
    private static final long serialVersionUID = 1L;
    private Long cpf;

    public Cpf(Long cpf) {
        this.cpf = cpf;
    }

    public String toString() {
        return this.format();
    }

    @Override
    public Long getRawValue() {
        return this.cpf;
    }

    public boolean isValid() {
        return this.isValid(this.unformat());
    }

    public String format() {
        if (this.cpf == null) {
            return null;
        }
        String cpfPadded = StringUtils.leftPad((String)this.cpf.toString(), (int)11, (char)'0');
        return String.format("%s.%s.%s-%s", cpfPadded.substring(0, 3), cpfPadded.substring(3, 6), cpfPadded.substring(6, 9), cpfPadded.substring(9, 11));
    }

    public String unformat() {
        if (this.cpf == null) {
            return null;
        }
        return this.format().replace(".", "").replace("-", "");
    }

    private boolean isValid(String cpf) {
        if (cpf == null) {
            return false;
        }
        DigitGenerator digitGenerator = new DigitGenerator();
        if (digitGenerator.hasAllRepeatedDigits(cpf)) {
            return false;
        }
        String cpfWithoutDigit = cpf.substring(0, cpf.length() - 2);
        String digits = cpf.substring(cpf.length() - 2);
        String calculatedDigits = this.calculateDigits(cpfWithoutDigit);
        return digits.equals(calculatedDigits);
    }

    private String calculateDigits(String cpfWithoutDigit) {
        Digits digits = new Digits(cpfWithoutDigit);
        digits.withMultipliers(2, 11).swapIfFind("0", 10, 11).mod(11);
        String digit1 = digits.calculate();
        digits.addDigit(digit1);
        String digit2 = digits.calculate();
        return digit1 + digit2;
    }
}

