/*
 * Decompiled with CFR 0.152.
 */
package br.com.damsete.arq.types;

import br.com.damsete.arq.types.Type;
import br.com.damsete.arq.utils.DigitGenerator;
import br.com.damsete.arq.utils.Digits;
import org.apache.commons.lang3.StringUtils;

public class Cnpj
implements Type<Long> {
    private static final long serialVersionUID = 1L;
    private Long cnpj;

    public Cnpj(Long cnpj) {
        this.cnpj = cnpj;
    }

    public String toString() {
        return this.format();
    }

    @Override
    public Long getRawValue() {
        return this.cnpj;
    }

    public boolean isValid() {
        return this.isValid(this.unformat());
    }

    public String format() {
        if (this.cnpj == null) {
            return null;
        }
        String cnpjPadded = StringUtils.leftPad((String)this.cnpj.toString(), (int)14, (char)'0');
        return String.format("%s.%s.%s/%s-%s", cnpjPadded.substring(0, 2), cnpjPadded.substring(2, 5), cnpjPadded.substring(5, 8), cnpjPadded.substring(8, 12), cnpjPadded.substring(12, 14));
    }

    public String unformat() {
        if (this.cnpj == null) {
            return null;
        }
        return this.format().replace(".", "").replace("-", "").replace("/", "");
    }

    private boolean isValid(String cnpj) {
        if (cnpj == null) {
            return false;
        }
        DigitGenerator digitGenerator = new DigitGenerator();
        if (digitGenerator.hasAllRepeatedDigits(cnpj)) {
            return false;
        }
        String cnpjWithoutDigit = cnpj.substring(0, cnpj.length() - 2);
        String digits = cnpj.substring(cnpj.length() - 2);
        String calculatedDigits = this.calculateDigits(cnpjWithoutDigit);
        return digits.equals(calculatedDigits);
    }

    private String calculateDigits(String cnpjWithoutDigit) {
        Digits digits = new Digits(cnpjWithoutDigit);
        digits.swapIfFind("0", 10, 11).mod(11);
        String digit1 = digits.calculate();
        digits.addDigit(digit1);
        String digit2 = digits.calculate();
        return digit1 + digit2;
    }
}

