/*
 * Decompiled with CFR 0.152.
 */
package br.com.damsete.arq.notifications;

import br.com.damsete.arq.notifications.Notification;
import br.com.damsete.arq.notifications.NotificationException;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class Notifiable {
    private transient List<Notification> notifications = Lists.newArrayList();

    protected Notifiable() {
    }

    public Notifiable addNotification(String code, Object ... args) {
        return this.addNotification(new Notification(code, args));
    }

    public Notifiable addNotification(Notification notification) {
        return this.addNotification(Collections.singletonList(notification));
    }

    public Notifiable addNotification(List<Notification> notifications) {
        this.notifications.addAll(notifications);
        return this;
    }

    public Notifiable addNotification(Notifiable notifiable) {
        return this.addNotification(notifiable.getNotifications());
    }

    public Notifiable addNotification(Notifiable ... notifiable) {
        Arrays.asList(notifiable).forEach(this::addNotification);
        return this;
    }

    public List<Notification> getNotifications() {
        return Collections.unmodifiableList(this.notifications);
    }

    public boolean valid() {
        return this.getNotifications().isEmpty();
    }

    public boolean invalid() {
        return !this.valid();
    }

    public void verify() {
        if (this.invalid()) {
            throw new NotificationException(this.getNotifications());
        }
    }
}

