/*
 * Decompiled with CFR 0.152.
 */
package br.com.damsete.arq.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Digits {
    private Map<Integer, String> substitutions;
    private List<Integer> multipliers = Lists.newArrayList();
    private List<Integer> numbers;
    private int module;

    public Digits(String patch) {
        char[] digits;
        this.substitutions = Maps.newHashMap();
        this.numbers = Lists.newLinkedList();
        this.withMultipliers(2, 9);
        this.mod(11);
        for (char digit : digits = patch.toCharArray()) {
            this.numbers.add(Character.getNumericValue(digit));
        }
        Collections.reverse(this.numbers);
    }

    public Digits withMultipliers(int begin, int end) {
        this.multipliers.clear();
        for (int i = begin; i <= end; ++i) {
            this.multipliers.add(i);
        }
        return this;
    }

    public Digits swapIfFind(String substituto, Integer ... i) {
        for (Integer integer : i) {
            this.substitutions.put(integer, substituto);
        }
        return this;
    }

    public Digits mod(int module) {
        this.module = module;
        return this;
    }

    public String calculate() {
        int sum = 0;
        int nextMultiplier = 0;
        for (int digit : this.numbers) {
            int multiplier = this.multipliers.get(nextMultiplier);
            int total = digit * multiplier;
            sum += total;
            nextMultiplier = this.nextMultiplier(nextMultiplier);
        }
        int result = sum % this.module;
        if (this.substitutions.containsKey(result = this.module - result)) {
            return this.substitutions.get(result);
        }
        return String.valueOf(result);
    }

    private int nextMultiplier(int multiplier) {
        if (++multiplier == this.multipliers.size()) {
            multiplier = 0;
        }
        return multiplier;
    }

    public Digits addDigit(String digit) {
        ((LinkedList)this.numbers).addFirst(Integer.valueOf(digit));
        return this;
    }
}

