package br.com.damsete.arq.utils;

import org.apache.commons.lang3.StringUtils;

import java.math.BigInteger;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;

public class Dates {

    private Dates() {
        super();
    }

    public static String formatLocalDate(LocalDate localDate, String pattern) {
        return localDate == null || StringUtils.isEmpty(pattern) ? null : DateTimeFormatter.ofPattern(pattern).format(localDate);
    }

    public static String formatLocalTime(LocalTime localTime, String pattern) {
        return localTime == null || StringUtils.isEmpty(pattern) ? null : DateTimeFormatter.ofPattern(pattern).format(localTime);
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime, String pattern) {
        return localDateTime == null || StringUtils.isEmpty(pattern) ? null :  DateTimeFormatter.ofPattern(pattern).format(localDateTime);
    }

    public static LocalDate parseLocalDate(String localDate, String pattern) {
        return StringUtils.isEmpty(localDate) || StringUtils.isEmpty(pattern) ? null : LocalDate.parse(localDate, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalTime parseLocalTime(String localTime, String pattern) {
        return StringUtils.isEmpty(localTime) || StringUtils.isEmpty(pattern) ? null : LocalTime.parse(localTime, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDateTime parseLocalDateTime(String localDateTime, String pattern) {
        return StringUtils.isEmpty(localDateTime) || StringUtils.isEmpty(pattern) ? null : LocalDateTime.parse(localDateTime, DateTimeFormatter.ofPattern(pattern));
    }

    public static int getCurrentSecond() {
        return LocalDateTime.now().getSecond();
    }

    public static int getCurrentMinute() {
        return LocalDateTime.now().getMinute();
    }

    public static int getCurrentHour() {
        return LocalDateTime.now().getHour();
    }

    public static int getCurrentDay() {
        return LocalDate.now().getDayOfMonth();
    }

    public static DayOfWeek getCurrentDayOfWeek() {
        return LocalDate.now().getDayOfWeek();
    }

    public static Month getCurrentMonth() {
        return LocalDate.now().getMonth();
    }

    public static int getCurrentYear() {
        return LocalDate.now().getYear();
    }

    public static LocalDate getCurrentDate() {
        return LocalDate.now();
    }

    public static LocalDateTime getCurrentDateTime() {
        return LocalDateTime.now();
    }

    public static LocalDate firstMonthDate(Month month, int year) {
        return LocalDate.of(year, month, 1);
    }

    public static LocalDate lastMonthDate(Month month, int year) {
        return LocalDate.of(year, month, 1).with(TemporalAdjusters.lastDayOfMonth());
    }

    public static Date asDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date asDate(LocalTime localTime) {
        Instant instant = localTime.atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant();
        BigInteger milis = BigInteger.valueOf(instant.getEpochSecond()).multiply(BigInteger.valueOf(1000));
        milis = milis.add(BigInteger.valueOf(instant.getNano()).divide(BigInteger.valueOf(1_000_000)));
        return new Date(milis.longValue());
    }

    public static Date asDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate asLocalDate(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }
}
