package br.com.damsete.arq.types;

import static org.apache.commons.lang3.StringUtils.leftPad;

public class ZipCode implements Type<String> {

    private static final long serialVersionUID = 1L;

    private String zipCode;

    public ZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    @Override
    public String toString() {
        return format();
    }

    public String getRawValue() {
        return zipCode;
    }

    public String format() {
        if (zipCode == null) {
            return null;
        }

        String zipCodePadded = leftPad(zipCode.toString(), 8, '0');
        return String.format("%s.%s-%s", zipCodePadded.substring(0, 2), zipCodePadded.substring(2, 5), zipCodePadded.substring(5, 8));
    }

    public String unformat() {
        if (zipCode == null) {
            return null;
        }

        return format().replace("-", "").replace(".", "");
    }
}
