package br.com.damsete.arq.types;

import static org.apache.commons.lang3.StringUtils.leftPad;

public class Rg implements Type<String> {

    private static final long serialVersionUID = 1L;

    private String rg;

    public Rg(String rg) {
        this.rg = rg;
    }

    @Override
    public String toString() {
        return format();
    }

    public String getRawValue() {
        return rg;
    }

    public String format() {
        if (rg == null) {
            return null;
        }

        String rgPadded = leftPad(rg.toString(), 9, '0');
        return String.format("%s.%s.%s-%s", rgPadded.substring(0, 2), rgPadded.substring(2, 5), rgPadded.substring(5, 8), rgPadded.substring(8, 9));
    }

    public String unformat() {
        if (rg == null) {
            return null;
        }

        return format().replace(".", "").replace("-", "");
    }
}