package br.com.damsete.arq.types;

import static org.apache.commons.lang3.StringUtils.leftPad;

public class Phone implements Type<String> {

    private static final long serialVersionUID = 1L;

    private String phone;

    public Phone(String phone) {
        this.phone = phone;
    }

    @Override
    public String toString() {
        return format();
    }

    public String getRawValue() {
        return phone;
    }

    public String format() {
        if (phone == null) {
            return null;
        }

        String phonePadded = leftPad(phone.toString(), 10, '0');
        return String.format("(%s)%s-%s", phonePadded.substring(0, 2), phonePadded.substring(2, 6), phonePadded.substring(6, 10));
    }

    public String unformat() {
        if (phone == null) {
            return null;
        }

        return format().replace("(", "").replace(")", "").replace("-", "");
    }
}
