package br.com.damsete.arq.types;

import static org.apache.commons.lang3.StringUtils.leftPad;

public class NitPis implements Type<String> {

    private static final long serialVersionUID = 1L;

    private String nitPis;

    public NitPis(String nitPis) {
        this.nitPis = nitPis;
    }

    @Override
    public String toString() {
        return format();
    }

    public String getRawValue() {
        return nitPis;
    }

    public String format() {
        if (nitPis == null) {
            return null;
        }

        String nitPisPadded = leftPad(nitPis.toString(), 11, '0');
        return String.format("%s.%s.%s-%s", nitPisPadded.substring(0, 3), nitPisPadded.substring(3, 8), nitPisPadded.substring(8, 10), nitPisPadded.substring(10));
    }

    public String unformat() {
        if (nitPis == null) {
            return null;
        }

        return format().replace(".", "").replace("-", "");
    }
}