package br.com.damsete.arq.types;

import br.com.damsete.arq.utils.DigitGenerator;
import br.com.damsete.arq.utils.Digits;

import static org.apache.commons.lang3.StringUtils.leftPad;

public class Cpf implements Type<String> {

    private static final long serialVersionUID = 1L;

    private String cpf;

    public Cpf(String cpf) {
        this.cpf = cpf;
    }

    @Override
    public String toString() {
        return format();
    }

    public String getRawValue() {
        return cpf;
    }

    public boolean isValid() {
        return isValid(unformat());
    }

    public String format() {
        if (cpf == null) {
            return null;
        }

        String cpfPadded = leftPad(cpf.toString(), 11, '0');
        return String.format("%s.%s.%s-%s", cpfPadded.substring(0, 3), cpfPadded.substring(3, 6), cpfPadded.substring(6, 9), cpfPadded.substring(9, 11));
    }

    public String unformat() {
        if (cpf == null) {
            return null;
        }

        return format().replace(".", "").replace("-", "");
    }

    private boolean isValid(String cpf) {
        if (cpf == null) {
            return false;
        }

        DigitGenerator digitGenerator = new DigitGenerator();
        if (digitGenerator.hasAllRepeatedDigits(cpf)) {
            return false;
        }

        String cpfWithoutDigit = cpf.substring(0, cpf.length() - 2);
        String digits = cpf.substring(cpf.length() - 2);

        String calculatedDigits = calculateDigits(cpfWithoutDigit);

        return digits.equals(calculatedDigits);
    }

    private String calculateDigits(String cpfWithoutDigit) {
        Digits digits = new Digits(cpfWithoutDigit);
        digits.withMultipliers(2, 11).swapIfFind("0", 10, 11).mod(11);

        String digit1 = digits.calculate();
        digits.addDigit(digit1);
        String digit2 = digits.calculate();

        return digit1 + digit2;
    }
}