package br.com.damsete.arq.types;

import br.com.damsete.arq.utils.DigitGenerator;
import br.com.damsete.arq.utils.Digits;

import static org.apache.commons.lang3.StringUtils.leftPad;

public class Cnpj implements Type<String> {

    private static final long serialVersionUID = 1L;

    private String cnpj;

    public Cnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    @Override
    public String toString() {
        return format();
    }

    public String getRawValue() {
        return cnpj;
    }

    public boolean isValid() {
        return isValid(unformat());
    }

    public String format() {
        if (cnpj == null) {
            return null;
        }

        String cnpjPadded = leftPad(cnpj.toString(), 14, '0');
        return String.format("%s.%s.%s/%s-%s", cnpjPadded.substring(0, 2), cnpjPadded.substring(2, 5), cnpjPadded.substring(5, 8), cnpjPadded.substring(8, 12), cnpjPadded.substring(12, 14));
    }

    public String unformat() {
        if (cnpj == null) {
            return null;
        }

        return format().replace(".", "").replace("-", "").replace("/", "");
    }

    private boolean isValid(String cnpj) {
        if (cnpj == null) {
            return false;
        }

        DigitGenerator digitGenerator = new DigitGenerator();
        if (digitGenerator.hasAllRepeatedDigits(cnpj)) {
            return false;
        }

        String cnpjWithoutDigit = cnpj.substring(0, cnpj.length() - 2);
        String digits = cnpj.substring(cnpj.length() - 2);

        String calculatedDigits = calculateDigits(cnpjWithoutDigit);

        return digits.equals(calculatedDigits);
    }

    private String calculateDigits(String cnpjWithoutDigit) {
        Digits digits = new Digits(cnpjWithoutDigit);
        digits.swapIfFind("0", 10, 11).mod(11);

        String digit1 = digits.calculate();
        digits.addDigit(digit1);
        String digit2 = digits.calculate();

        return digit1 + digit2;
    }
}