/*
 * Decompiled with CFR 0.152.
 */
package br.com.damsete.arq.email.service;

import br.com.damsete.arq.email.appender.EmailMessage;
import br.com.damsete.arq.log.core.LogPersistable;
import br.com.damsete.arq.log.core.LoggerAPI;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import org.apache.logging.log4j.Level;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Service
public class SendEmailMessageService {
    private Configuration freemarkerConfig;
    private JavaMailSender mailSender;

    @Autowired
    public SendEmailMessageService(Configuration freemarkerConfig, JavaMailSender mailSender) {
        this.freemarkerConfig = freemarkerConfig;
        this.mailSender = mailSender;
    }

    @Async
    public void send(EmailMessage message) {
        this.mailSender.send(message.toMimeMessage());
        LoggerAPI.log((Level)Level.INFO, (LogPersistable)message);
    }

    @Async
    public void send(EmailMessage message, String template) {
        try {
            Template t = this.freemarkerConfig.getTemplate(template);
            String content = FreeMarkerTemplateUtils.processTemplateIntoString((Template)t, message.getModel());
            message = message.withContent(content);
            this.mailSender.send(message.toMimeMessage());
            LoggerAPI.log((Level)Level.INFO, (LogPersistable)message);
        }
        catch (TemplateException | IOException e) {
            LoggerAPI.log((Level)Level.ERROR, (LogPersistable)message);
        }
    }

    @Async
    public void send(Iterable<EmailMessage> messages) {
        messages.forEach(this::send);
    }

    @Async
    public void send(Iterable<EmailMessage> messages, String template) {
        messages.forEach(m -> this.send((EmailMessage)m, template));
    }
}

