/*
 * Decompiled with CFR 0.152.
 */
package br.com.damsete.arq.email.helper;

import br.com.damsete.arq.email.appender.EmailMessageAttachment;
import br.com.damsete.arq.email.appender.EmailMessageRecipient;
import br.com.damsete.arq.email.appender.EmailMessageReplyTo;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.springframework.mail.javamail.MimeMessageHelper;

public class EmailMessageHelper {
    private List<EmailMessageAttachment> attachments = Lists.newArrayList();
    private List<EmailMessageRecipient> recipients = Lists.newArrayList();
    private List<EmailMessageReplyTo> replyToList = Lists.newArrayList();

    public void addAttachment(MimeMessageHelper helper) throws MessagingException {
        for (EmailMessageAttachment a : this.attachments) {
            helper.addAttachment(a.getFileName(), a.getSource());
        }
    }

    public void addAttachment(EmailMessageAttachment attachment) {
        this.attachments.add(attachment);
    }

    public void addRecipient(MimeMessage m) throws MessagingException, UnsupportedEncodingException {
        for (EmailMessageRecipient r : this.recipients) {
            m.addRecipient(r.getType(), (Address)new InternetAddress(r.getToAddress(), r.getToName()));
        }
    }

    public void addRecipient(EmailMessageRecipient recipient) {
        this.recipients.add(recipient);
    }

    public void addReplyTo(MimeMessage m) throws UnsupportedEncodingException, MessagingException {
        ArrayList replyTos = Lists.newArrayListWithExpectedSize((int)this.replyToList.size());
        for (EmailMessageReplyTo r : this.replyToList) {
            replyTos.add(new InternetAddress(r.getReplyToAddress(), r.getReplyToName()));
        }
        m.setReplyTo((Address[])Iterables.toArray((Iterable)replyTos, InternetAddress.class));
    }

    public void addReplyTo(EmailMessageReplyTo replyTo) {
        this.replyToList.add(replyTo);
    }

    public List<EmailMessageRecipient> getRecipients() {
        return Collections.unmodifiableList(this.recipients);
    }

    public List<EmailMessageReplyTo> getReplyToList() {
        return Collections.unmodifiableList(this.replyToList);
    }
}

