/*
 * Decompiled with CFR 0.152.
 */
package br.com.damsete.arq.email.appender;

import br.com.damsete.arq.email.appender.EmailMessageAttachment;
import br.com.damsete.arq.email.appender.EmailMessageRecipient;
import br.com.damsete.arq.email.appender.EmailMessageReplyTo;
import br.com.damsete.arq.email.helper.EmailMessageHelper;
import br.com.damsete.arq.log.core.LogPersistable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class EmailMessage
implements LogPersistable {
    private boolean html = true;
    private String fromAddress = null;
    private String fromName = null;
    private String subject = null;
    private String content = null;
    private String confirmationAddress = null;
    private Map<String, Object> model = Maps.newHashMap();
    private EmailMessageHelper emailMessageHelper = new EmailMessageHelper();

    private EmailMessage() {
    }

    public static EmailMessage asPlainText() {
        EmailMessage mm = new EmailMessage();
        mm.html = false;
        return mm;
    }

    public static EmailMessage asHtml() {
        EmailMessage mm = new EmailMessage();
        mm.html = true;
        return mm;
    }

    public EmailMessage from(String fromName, String fromAddress) {
        this.fromName = fromName;
        this.fromAddress = fromAddress;
        return this;
    }

    public EmailMessage addTo(String toName, String toAddress) {
        this.emailMessageHelper.addRecipient(new EmailMessageRecipient(toName, toAddress, Message.RecipientType.TO));
        return this;
    }

    public EmailMessage addCc(String toName, String toAddress) {
        this.emailMessageHelper.addRecipient(new EmailMessageRecipient(toName, toAddress, Message.RecipientType.CC));
        return this;
    }

    public EmailMessage addBcc(String toName, String toAddress) {
        this.emailMessageHelper.addRecipient(new EmailMessageRecipient(toName, toAddress, Message.RecipientType.BCC));
        return this;
    }

    public EmailMessage addReplyTo(String replyToName, String replyToAddress) {
        this.emailMessageHelper.addReplyTo(new EmailMessageReplyTo(replyToName, replyToAddress));
        return this;
    }

    public EmailMessage withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public EmailMessage withContent(String content) {
        this.content = content;
        return this;
    }

    public EmailMessage withConfirmationTo(String confirmationAddress) {
        this.confirmationAddress = confirmationAddress;
        return this;
    }

    public EmailMessage addAttachment(String fileName, InputStreamSource source) {
        this.emailMessageHelper.addAttachment(new EmailMessageAttachment(fileName, source));
        return this;
    }

    public EmailMessage addModelParam(String key, Object value) {
        this.model.put(key, value);
        return this;
    }

    public EmailMessage withMessageHelper(EmailMessageHelper helper) {
        this.emailMessageHelper = helper;
        return this;
    }

    public Map<String, Object> getModel() {
        return this.model;
    }

    public boolean isHtml() {
        return this.html;
    }

    public MimeMessagePreparator toMimeMessage() {
        return this::prepare;
    }

    public String getLog() {
        if (StringUtils.isEmpty((CharSequence)this.fromAddress)) {
            this.fromAddress = "";
        }
        if (StringUtils.isEmpty((CharSequence)this.fromName)) {
            this.fromName = "";
        }
        if (StringUtils.isEmpty((CharSequence)this.subject)) {
            this.subject = "";
        }
        if (StringUtils.isEmpty((CharSequence)this.content)) {
            this.content = "";
        }
        if (StringUtils.isEmpty((CharSequence)this.confirmationAddress)) {
            this.confirmationAddress = "";
        }
        return String.format("%s %s %s %s %s %s %s %s", this.html, this.fromAddress, this.fromName, this.subject, this.content, this.confirmationAddress, Iterables.toString(this.emailMessageHelper.getRecipients()), Iterables.toString(this.emailMessageHelper.getReplyToList()));
    }

    void prepare(MimeMessage m) {
        try {
            MimeMessageHelper helper = new MimeMessageHelper(m, true);
            m.setFrom((Address)new InternetAddress(this.fromAddress, this.fromName));
            m.setSubject(this.subject);
            m.setSentDate(new Date());
            if (StringUtils.isNotEmpty((CharSequence)this.confirmationAddress)) {
                m.setHeader("Return-Receipt-To", this.confirmationAddress);
            }
            helper.setText(this.content, this.html);
            this.emailMessageHelper.addRecipient(m);
            this.emailMessageHelper.addReplyTo(m);
            this.emailMessageHelper.addAttachment(helper);
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            throw new IllegalArgumentException("Fail to prepare MimeMessage.", e);
        }
    }
}

