/*
 * Decompiled with CFR 0.152.
 */
package br.com.concretesolutions.requestmatcher.exception;

import br.com.concretesolutions.requestmatcher.RequestMatchersGroup;
import okhttp3.Headers;
import okhttp3.mockwebserver.RecordedRequest;

public class NoMatchersForRequestException
extends RuntimeException {
    private static final String PRE_WITH_REQ = "No matcher found for request: \n\n";

    private NoMatchersForRequestException(Builder builder) {
        super(builder.sb.toString());
    }

    private static StringBuilder buildRequestMessage(StringBuilder sb, RecordedRequest request) {
        sb.append("> ").append(request.getRequestLine());
        Headers headers = request.getHeaders();
        int count = headers.size();
        for (int i = 0; i < count; ++i) {
            sb.append("\n> ").append(headers.name(i)).append(": ").append(headers.value(i));
        }
        String body = request.getBody().clone().readUtf8();
        return body.isEmpty() ? sb : sb.append("\n\n").append(body);
    }

    public static class Builder {
        private final StringBuilder sb = new StringBuilder("No matcher found for request: \n\n");

        public Builder(RecordedRequest request) {
            NoMatchersForRequestException.buildRequestMessage(this.sb, request).append("\n\nTried the following matchers:\n");
        }

        public Builder appendAssertionError(int order, AssertionError error, RequestMatchersGroup matcher) {
            this.sb.append('\n').append(order).append(". ");
            String message = ((Throwable)((Object)error)).toString().substring(error.getClass().getCanonicalName().length() + 1);
            matcher.buildExpectedMatchers(this.sb).append("\n Failed because").append(message.replaceAll("\n", "\n ")).append('\n');
            return this;
        }

        public NoMatchersForRequestException build() {
            return new NoMatchersForRequestException(this);
        }
    }
}

