/*
 * Decompiled with CFR 0.152.
 */
package br.com.concretesolutions.requestmatcher;

import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;

final class IOReader {
    static String read(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("Could not open resource stream.");
        }
        BufferedReader bis = new BufferedReader(new InputStreamReader(is));
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            while ((line = bis.readLine()) != null) {
                builder.append(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read resource fully", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                Log.e((String)IOReader.class.getSimpleName(), (String)"Error while trying to close stream", (Throwable)e);
            }
        }
        return builder.append("\n").toString();
    }

    static byte[] readBinary(InputStream is) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        try {
            int nRead;
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read resource fully", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                Log.e((String)IOReader.class.getSimpleName(), (String)"Error while trying to close stream", (Throwable)e);
            }
        }
    }

    static String mimeTypeFromExtension(String path) {
        String ext;
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        int indexOfDot = path.lastIndexOf(46);
        if (indexOfDot == -1) {
            return null;
        }
        switch (ext = path.substring(indexOfDot + 1).toLowerCase(Locale.getDefault())) {
            case "json": {
                return "application/json";
            }
            case "xml": {
                return "text/xml";
            }
            case "txt": {
                return "text/plain";
            }
            case "html": {
                return "text/html";
            }
            case "js": {
                return "text/javascript";
            }
            case "htm": {
                return "text/html";
            }
            case "css": {
                return "text/css";
            }
            case "png": {
                return "image/png";
            }
            case "jpg": {
                return "image/jpeg";
            }
            case "gif": {
                return "image/gif";
            }
            case "pdf": {
                return "application/pdf";
            }
        }
        return null;
    }

    private IOReader() {
    }
}

