/*
 * Decompiled with CFR 0.152.
 */
package br.com.concretesolutions.requestmatcher;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.mockwebserver.RecordedRequest;

public final class RequestUtils {
    public static Map<String, String> buildQueryMap(String path) {
        HashMap<String, String> queries = new HashMap<String, String>();
        String queryString = path.substring(path.indexOf(63) + 1);
        String[] queryParts = queryString.split("&");
        if (queryParts.length == 0) {
            return queries;
        }
        for (String part : queryParts) {
            String[] split = part.split("=");
            queries.put(split[0], split[1]);
        }
        return queries;
    }

    public static Map<String, String> buildHeadersMap(Headers headers) {
        Map stringListMap = headers.toMultimap();
        HashMap<String, String> headersMap = new HashMap<String, String>(headers.size());
        StringBuilder headerValue = new StringBuilder();
        for (String key : stringListMap.keySet()) {
            List values = (List)stringListMap.get(key);
            for (int i = 0; i < values.size(); ++i) {
                if (i > 0) {
                    headerValue.append(';');
                }
                headerValue.append((String)values.get(i));
            }
            headersMap.put(key, headerValue.toString());
            headerValue.setLength(0);
        }
        return headersMap;
    }

    public static String getPathOnly(RecordedRequest request) {
        String path = request.getPath();
        if (!path.contains("?")) {
            return path;
        }
        return path.substring(0, path.indexOf(63));
    }
}

