/*
 * Decompiled with CFR 0.152.
 */
package br.com.concretesolutions.requestmatcher;

import br.com.concretesolutions.requestmatcher.RequestUtils;
import br.com.concretesolutions.requestmatcher.matchers.IsMapWithSize;
import br.com.concretesolutions.requestmatcher.model.HttpMethod;
import java.util.HashMap;
import java.util.Map;
import okhttp3.mockwebserver.RecordedRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class RequestMatchersGroup {
    private Matcher<String> bodyMatcher;
    private Matcher<String> pathMatcher;
    private Matcher<HttpMethod> methodMatcher;
    private Matcher<Integer> orderMatcher;
    private Matcher<Map<? extends String, ? extends String>> queryMatcher;
    private Matcher<Map<? extends String, ? extends String>> headersMatcher;
    private Matcher<Object> jsonMatcher;

    public void doAssert(RecordedRequest request) {
        if (this.methodMatcher != null) {
            MatcherAssert.assertThat((Object)((Object)HttpMethod.forRequest(request)), this.methodMatcher);
        }
        if (this.pathMatcher != null) {
            MatcherAssert.assertThat((Object)RequestUtils.getPathOnly(request), this.pathMatcher);
        }
        String path = request.getPath();
        if (this.queryMatcher != null) {
            if (!path.contains("?")) {
                MatcherAssert.assertThat(new HashMap(0), this.queryMatcher);
            } else {
                MatcherAssert.assertThat(RequestUtils.buildQueryMap(path), this.queryMatcher);
            }
        }
        if (this.headersMatcher != null) {
            MatcherAssert.assertThat(RequestUtils.buildHeadersMap(request.getHeaders()), this.headersMatcher);
        }
        String body = request.getBody().readUtf8();
        if (this.bodyMatcher != null) {
            MatcherAssert.assertThat((Object)body, this.bodyMatcher);
        }
        if (this.jsonMatcher != null) {
            MatcherAssert.assertThat((Object)body, this.jsonMatcher);
        }
    }

    public void assertOrder(int currentOrder) {
        if (this.orderMatcher != null) {
            MatcherAssert.assertThat((Object)currentOrder, this.orderMatcher);
        }
    }

    public RequestMatchersGroup hasEmptyBody() {
        this.checkIsNull(this.bodyMatcher, "Body assertion is already set");
        this.bodyMatcher = Matchers.isEmptyOrNullString();
        return this;
    }

    public RequestMatchersGroup hasNoQueries() {
        this.checkIsNull(this.queryMatcher, "Query assertion is already set");
        this.queryMatcher = IsMapWithSize.anEmptyMap();
        return this;
    }

    public RequestMatchersGroup pathIs(String path) {
        this.checkIsNull(this.pathMatcher, "Path assertion is already set");
        this.pathMatcher = Matchers.is((Object)path);
        return this;
    }

    public RequestMatchersGroup methodIs(HttpMethod method) {
        this.checkIsNull(this.methodMatcher, "Method assertion is already set");
        this.methodMatcher = Matchers.is((Object)((Object)method));
        return this;
    }

    public RequestMatchersGroup orderIs(int order) {
        this.checkIsNull(this.orderMatcher, "Order assertion is already set");
        this.orderMatcher = Matchers.is((Object)order);
        return this;
    }

    public RequestMatchersGroup queriesContain(String queryKey, String queryValue) {
        this.queryMatcher = this.queryMatcher != null ? Matchers.allOf((Matcher)Matchers.hasEntry((Object)queryKey, (Object)queryValue), this.queryMatcher) : Matchers.hasEntry((Object)queryKey, (Object)queryValue);
        return this;
    }

    public RequestMatchersGroup headersContain(String headerKey, String headerValue) {
        this.headersMatcher = this.headersMatcher != null ? Matchers.allOf((Matcher)Matchers.hasEntry((Object)headerKey, (Object)headerValue), this.headersMatcher) : Matchers.hasEntry((Object)headerKey, (Object)headerValue);
        return this;
    }

    public RequestMatchersGroup pathMatches(Matcher<String> pathMatcher) {
        this.checkIsNull(this.pathMatcher, "Path assertion is already set");
        this.pathMatcher = pathMatcher;
        return this;
    }

    public RequestMatchersGroup methodMatches(Matcher<HttpMethod> methodMatcher) {
        this.checkIsNull(this.methodMatcher, "Method assertion is already set");
        this.methodMatcher = methodMatcher;
        return this;
    }

    public RequestMatchersGroup queriesMatches(Matcher<Map<? extends String, ? extends String>> queryMatcher) {
        this.queryMatcher = this.queryMatcher != null ? Matchers.allOf(queryMatcher, this.queryMatcher) : queryMatcher;
        return this;
    }

    public RequestMatchersGroup headersMatches(Matcher<Map<? extends String, ? extends String>> headersMatcher) {
        this.headersMatcher = this.headersMatcher != null ? Matchers.allOf(headersMatcher, this.headersMatcher) : headersMatcher;
        return this;
    }

    public RequestMatchersGroup bodyMatches(Matcher<String> bodyMatcher) {
        this.bodyMatcher = this.bodyMatcher != null ? Matchers.allOf(bodyMatcher, this.bodyMatcher) : bodyMatcher;
        return this;
    }

    public RequestMatchersGroup bodyAsJsonMatches(Matcher<Object> jsonMatcher) {
        this.jsonMatcher = this.jsonMatcher != null ? Matchers.allOf(jsonMatcher, this.jsonMatcher) : jsonMatcher;
        return this;
    }

    private void checkIsNull(Object target, String message) {
        if (target != null) {
            throw new IllegalStateException(message);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RequestMatchersGroup{");
        if (this.bodyMatcher != null) {
            sb.append("\n\tbodyMatcher = ").append(this.bodyMatcher);
        }
        if (this.jsonMatcher != null) {
            sb.append("\n\tjsonMatcher = ").append(this.jsonMatcher);
        }
        if (this.pathMatcher != null) {
            sb.append(",\n\tpathMatcher = ").append(this.pathMatcher);
        }
        if (this.methodMatcher != null) {
            sb.append(",\n\tmethodMatcher = ").append(this.methodMatcher);
        }
        if (this.orderMatcher != null) {
            sb.append(",\n\torderMatcher = ").append(this.orderMatcher);
        }
        if (this.queryMatcher != null) {
            sb.append(",\n\tqueryMatcher = ").append(this.queryMatcher);
        }
        if (this.headersMatcher != null) {
            sb.append(",\n\theadersMatcher = ").append(this.headersMatcher);
        }
        sb.append("\n}");
        return sb.toString();
    }
}

