/*
 * Decompiled with CFR 0.152.
 */
package br.com.concretesolutions.requestmatcher;

import br.com.concretesolutions.requestmatcher.IOReader;
import br.com.concretesolutions.requestmatcher.MatcherDispatcher;
import br.com.concretesolutions.requestmatcher.RequestMatchersGroup;
import br.com.concretesolutions.requestmatcher.exception.RequestAssertionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class RequestMatcherRule
implements TestRule {
    private final MatcherDispatcher dispatcher = new MatcherDispatcher();
    private final MockWebServer server;
    private final String fixturesRootFolder;
    private final Map<String, String> defaultHeaders = new HashMap<String, String>();
    private boolean guessMimeType = true;

    RequestMatcherRule() {
        this(new MockWebServer());
    }

    RequestMatcherRule(String fixturesRootFolder) {
        this(new MockWebServer(), fixturesRootFolder);
    }

    RequestMatcherRule(MockWebServer server) {
        this(server, "fixtures");
    }

    RequestMatcherRule(MockWebServer server, String fixturesRootFolder) {
        this.server = server;
        this.fixturesRootFolder = fixturesRootFolder;
    }

    protected abstract InputStream open(String var1) throws IOException;

    public Statement apply(Statement base, Description description) {
        return this.server.apply(this.requestAssertionStatement(base), description);
    }

    public RequestMatcherRule withDefaultHeader(String key, String value) {
        this.defaultHeaders.put(key, value);
        return this;
    }

    public RequestMatcherRule withGuessingMimeTypeFromFixtureExtension(boolean guess) {
        this.guessMimeType = guess;
        return this;
    }

    public HttpUrl url(String path) {
        return this.server.url(path);
    }

    public MockWebServer getMockWebServer() {
        return this.server;
    }

    public String readFixture(String fixturePath) {
        try {
            return IOReader.read(this.open(this.fixturesRootFolder + "/" + fixturePath)) + "\n";
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read asset with path " + fixturePath, e);
        }
    }

    public <T extends RequestMatchersGroup> IfRequestMatches<T> addResponse(MockResponse response, T matcher) {
        return new IfRequestMatches<T>(this.dispatcher.addFixture(response, matcher));
    }

    public IfRequestMatches<RequestMatchersGroup> addResponse(MockResponse response) {
        return new IfRequestMatches<RequestMatchersGroup>(this.dispatcher.addFixture(response));
    }

    public IfRequestMatches<RequestMatchersGroup> addFixture(String fixturePath) {
        return this.addFixture(200, fixturePath);
    }

    public IfRequestMatches<RequestMatchersGroup> addFixture(int statusCode, String fixturePath) {
        String mimeType;
        MockResponse mockResponse = new MockResponse().setResponseCode(statusCode).setBody(this.readFixture(fixturePath));
        if (this.guessMimeType && (mimeType = IOReader.mimeTypeFromExtension(fixturePath)) != null) {
            mockResponse.addHeader("Content-Type", (Object)mimeType);
        }
        if (!this.defaultHeaders.isEmpty()) {
            for (String headerKey : this.defaultHeaders.keySet()) {
                mockResponse.addHeader(headerKey, (Object)this.defaultHeaders.get(headerKey));
            }
        }
        return this.addResponse(mockResponse);
    }

    public <T extends RequestMatchersGroup> IfRequestMatches<T> addFixture(String fixturePath, T matcher) {
        return this.addResponse(new MockResponse().setResponseCode(200).setBody(this.readFixture(fixturePath)), matcher);
    }

    public <T extends RequestMatchersGroup> IfRequestMatches<T> addFixture(int statusCode, String fixturePath, T matcher) {
        return this.addResponse(new MockResponse().setResponseCode(statusCode).setBody(this.readFixture(fixturePath)), matcher);
    }

    private void after(Exception exception, boolean success) throws Exception {
        if (this.dispatcher.getAssertionException() != null) {
            if (exception != null) {
                Logger.getLogger(RequestMatcherRule.class.getName()).log(Level.SEVERE, "Test threw exception.", exception);
            }
            throw this.dispatcher.getAssertionException();
        }
        if (!success) {
            if (exception != null) {
                throw exception;
            }
            return;
        }
        if (this.dispatcher.size() != 0) {
            try {
                Assert.fail((String)"There are fixtures that were not used.");
            }
            catch (AssertionError e) {
                throw new RequestAssertionException("Failed assertion.", (Throwable)((Object)e));
            }
        }
    }

    private Statement requestAssertionStatement(final Statement base) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                RequestMatcherRule.this.server.setDispatcher((Dispatcher)RequestMatcherRule.this.dispatcher);
                boolean success = false;
                Exception exception = null;
                try {
                    base.evaluate();
                    success = true;
                }
                catch (Exception e) {
                    exception = e;
                }
                finally {
                    RequestMatcherRule.this.after(exception, success);
                }
            }
        };
    }

    public static class IfRequestMatches<T extends RequestMatchersGroup> {
        private final T group;

        IfRequestMatches(T group) {
            this.group = group;
        }

        public T ifRequestMatches() {
            return this.group;
        }
    }
}

