/*
 * Decompiled with CFR 0.152.
 */
package br.com.concretesolutions.requestmatcher;

import br.com.concretesolutions.requestmatcher.RequestMatchersGroup;
import br.com.concretesolutions.requestmatcher.exception.NoMatchersForRequestException;
import br.com.concretesolutions.requestmatcher.exception.OrderException;
import br.com.concretesolutions.requestmatcher.exception.RequestAssertionException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.mockwebserver.SocketPolicy;

public final class MatcherDispatcher
extends Dispatcher {
    private static final Logger logger = Logger.getLogger(MatcherDispatcher.class.getName());
    private static final String ASSERT_HEADER = "REQUEST-ASSERT";
    protected final Set<ResponseWithMatcher> responseSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private RequestAssertionException assertionError;
    private AtomicInteger order = new AtomicInteger();

    public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
        Thread.sleep(50L);
        int currentOrder = this.order.incrementAndGet();
        for (ResponseWithMatcher response : this.responseSet) {
            RequestMatchersGroup matcher = response.getMatcher();
            if (matcher == null) continue;
            try {
                matcher.doAssert(request);
                matcher.assertOrder(currentOrder);
                this.responseSet.remove(response);
                return response.getResponse();
            }
            catch (AssertionError assertionError) {
            }
            catch (OrderException e) {
                this.assertionError = new RequestAssertionException("Wrong orderIs of requests.", e);
                return new MockResponse().setSocketPolicy(SocketPolicy.DISCONNECT_AT_END);
            }
            catch (Exception e) {
                this.assertionError = new RequestAssertionException("Unexpected exception during assertion.", e);
                logger.log(Level.SEVERE, "Error while doing assert", e);
                return response.getResponse();
            }
        }
        this.assertionError = new RequestAssertionException("Unexpected exception during assertion.", new NoMatchersForRequestException(this.responseSet));
        return new MockResponse().setSocketPolicy(SocketPolicy.DISCONNECT_AT_END);
    }

    public RequestAssertionException getAssertionException() {
        return this.assertionError;
    }

    public int size() {
        return this.responseSet.size();
    }

    public RequestMatchersGroup addFixture(MockResponse response) {
        return this.addFixture(response, new RequestMatchersGroup());
    }

    public <T extends RequestMatchersGroup> T addFixture(MockResponse response, T requestMatcher) {
        String assertPath = response.hashCode() + "::" + System.identityHashCode(requestMatcher);
        this.responseSet.add(new ResponseWithMatcher(requestMatcher, response.setHeader(ASSERT_HEADER, (Object)assertPath)));
        return requestMatcher;
    }

    public static class ResponseWithMatcher {
        private final MockResponse response;
        private final RequestMatchersGroup matcher;

        public ResponseWithMatcher(RequestMatchersGroup matcher, MockResponse response) {
            this.matcher = matcher;
            this.response = response;
        }

        public MockResponse getResponse() {
            return this.response;
        }

        public RequestMatchersGroup getMatcher() {
            return this.matcher;
        }
    }
}

