/*
 * Decompiled with CFR 0.152.
 */
package br.com.concretesolutions.requestmatcher;

import br.com.concretesolutions.requestmatcher.RequestAssertionException;
import br.com.concretesolutions.requestmatcher.RequestMatcher;
import br.com.concretesolutions.requestmatcher.model.MatcherMockResponse;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.mockwebserver.SocketPolicy;

public class MatcherQueueDispatcher
extends Dispatcher {
    private static final Logger logger = Logger.getLogger(MatcherQueueDispatcher.class.getName());
    private static final String ASSERT_HEADER = "REQUEST-ASSERT";
    private static final String ERROR_MESSAGE = "Failed assertion for %s";
    protected final BlockingQueue<MatcherMockResponse> responseQueue = new LinkedBlockingQueue<MatcherMockResponse>();
    private final MockResponse disconnectResponse = new MockResponse().setSocketPolicy(SocketPolicy.DISCONNECT_AT_START);
    private MockResponse failFastResponse;
    private RequestAssertionException assertionError;

    public BlockingQueue<MatcherMockResponse> getQueue() {
        return this.responseQueue;
    }

    public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
        String requestLine = request.getRequestLine();
        if (requestLine != null && requestLine.equals("GET /favicon.ico HTTP/1.1")) {
            logger.info("served " + requestLine);
            return new MockResponse().setResponseCode(404);
        }
        if (this.failFastResponse != null && this.responseQueue.peek() == null) {
            return this.failFastResponse;
        }
        MatcherMockResponse response = this.responseQueue.take();
        RequestMatcher matcher = response.getMatcher();
        if (matcher != null) {
            try {
                matcher.doAssert(request);
            }
            catch (AssertionError e) {
                this.assertionError = new RequestAssertionException(String.format(ERROR_MESSAGE, request), (Error)((Object)e));
                return new MockResponse().setSocketPolicy(SocketPolicy.DISCONNECT_AT_END);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error while doing assert", e);
                return response.getResponse();
            }
        }
        return response.getResponse();
    }

    public MockResponse peek() {
        MatcherMockResponse peek = (MatcherMockResponse)this.responseQueue.peek();
        if (peek != null) {
            return peek.getResponse();
        }
        if (this.failFastResponse != null) {
            return this.failFastResponse;
        }
        return super.peek();
    }

    public void setFailFast(boolean failFast) {
        MockResponse failFastResponse = failFast ? new MockResponse().setResponseCode(404) : null;
        this.setFailFast(failFastResponse);
    }

    public void setFailFast(MockResponse failFastResponse) {
        this.failFastResponse = failFastResponse;
    }

    public RequestMatcher enqueue(MockResponse response) {
        return this.enqueue(response, new RequestMatcher());
    }

    public <T extends RequestMatcher> T enqueue(MockResponse response, T requestMatcher) {
        String assertPath = response.hashCode() + "::" + System.identityHashCode(requestMatcher);
        this.responseQueue.add(new MatcherMockResponse(requestMatcher, response.setHeader(ASSERT_HEADER, (Object)assertPath)));
        return requestMatcher;
    }

    public RequestMatcher enqueueDisconnect() {
        return this.enqueue(this.disconnectResponse);
    }

    public RequestAssertionException getAssertionException() {
        return this.assertionError;
    }
}

