/*
 * Decompiled with CFR 0.152.
 */
package br.com.concretesolutions.requestmatcher;

import br.com.concretesolutions.requestmatcher.model.Query;
import java.util.HashSet;
import java.util.Set;
import okhttp3.mockwebserver.RecordedRequest;

public final class RequestUtils {
    public static boolean hasQuery(String path) {
        return path.contains("?");
    }

    public static String getBody(RecordedRequest request) {
        return request.getBody().readUtf8();
    }

    public static Set<Query> buildQueries(String path) {
        String[] queryParts;
        HashSet<Query> queries = new HashSet<Query>();
        String queryString = path.substring(path.indexOf(63) + 1);
        for (String part : queryParts = queryString.split("&")) {
            String[] split = part.split("=");
            queries.add(Query.of(split[0], split[1]));
        }
        return queries;
    }

    public static String getPathOnly(RecordedRequest request) {
        String path = request.getPath();
        if (!RequestUtils.hasQuery(path)) {
            return path;
        }
        return path.substring(0, path.indexOf(63));
    }
}

