/*
 * Decompiled with CFR 0.152.
 */
package br.com.concretesolutions.requestmatcher;

import br.com.concretesolutions.requestmatcher.IOReader;
import br.com.concretesolutions.requestmatcher.MatcherQueueDispatcher;
import br.com.concretesolutions.requestmatcher.RequestAssertionError;
import br.com.concretesolutions.requestmatcher.RequestMatcher;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class RequestMatcherRule
implements TestRule {
    private final MatcherQueueDispatcher dispatcher = new MatcherQueueDispatcher();
    private final MockWebServer server;
    private final String fixturesRootFolder;

    public RequestMatcherRule() {
        this(new MockWebServer());
    }

    public RequestMatcherRule(String fixturesRootFolder) {
        this(new MockWebServer(), fixturesRootFolder);
    }

    public RequestMatcherRule(MockWebServer server) {
        this(server, "fixtures");
    }

    public RequestMatcherRule(MockWebServer server, String fixturesRootFolder) {
        this.server = server;
        this.fixturesRootFolder = fixturesRootFolder;
    }

    protected abstract InputStream open(String var1) throws IOException;

    public Statement apply(Statement base, Description description) {
        return this.server.apply(this.requestAssertionStatement(base), description);
    }

    public HttpUrl url(String path) {
        return this.server.url(path);
    }

    public MockWebServer getMockWebServer() {
        return this.server;
    }

    public String readFixture(String assetPath) {
        try {
            return IOReader.read(this.open(this.fixturesRootFolder + "/" + assetPath)) + "\n";
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read asset with path " + assetPath, e);
        }
    }

    public RequestMatcher enqueue(MockResponse response) {
        return this.dispatcher.enqueue(response);
    }

    public RequestMatcher enqueueNoBody(int statusCode) {
        return this.enqueue(new MockResponse().setResponseCode(statusCode).setBody(""));
    }

    public RequestMatcher enqueue(int statusCode, String assetPath) {
        return this.enqueue(new MockResponse().setResponseCode(statusCode).setBody(this.readFixture(assetPath)));
    }

    public RequestMatcher enqueueGET(int statusCode) {
        return this.enqueueNoBody(statusCode).assertNoBody().assertMethodIs("GET");
    }

    public RequestMatcher enqueueGET(int statusCode, String assetPath) {
        return this.enqueue(statusCode, assetPath).assertNoBody().assertMethodIs("GET");
    }

    public RequestMatcher enqueuePOST(int statusCode) {
        return this.enqueueNoBody(statusCode).assertMethodIs("POST");
    }

    public RequestMatcher enqueuePOST(int statusCode, String assetPath) {
        return this.enqueue(statusCode, assetPath).assertMethodIs("POST");
    }

    public RequestMatcher enqueuePUT(int statusCode) {
        return this.enqueueNoBody(statusCode).assertMethodIs("PUT");
    }

    public RequestMatcher enqueuePUT(int statusCode, String assetPath) {
        return this.enqueue(statusCode, assetPath).assertMethodIs("PUT");
    }

    public RequestMatcher enqueueDELETE(int statusCode) {
        return this.enqueueNoBody(statusCode).assertMethodIs("PUT");
    }

    public RequestMatcher enqueueDELETE(int statusCode, String assetPath) {
        return this.enqueue(statusCode, assetPath).assertMethodIs("PUT");
    }

    private void after(boolean success) {
        if (this.dispatcher.getAssertionError() != null) {
            throw this.dispatcher.getAssertionError();
        }
        if (!success) {
            return;
        }
        if (this.dispatcher.getQueue().size() != 0) {
            try {
                Assert.fail((String)"There are enqueued requests that were not used.");
            }
            catch (AssertionError e) {
                throw new RequestAssertionError("Failed assertion.", (Error)((Object)e));
            }
        }
    }

    private Statement requestAssertionStatement(final Statement base) {
        return new Statement(){

            public void evaluate() throws Throwable {
                RequestMatcherRule.this.server.setDispatcher((Dispatcher)RequestMatcherRule.this.dispatcher);
                boolean success = false;
                try {
                    base.evaluate();
                    success = true;
                }
                finally {
                    RequestMatcherRule.this.after(success);
                }
            }
        };
    }
}

