/*
 * Decompiled with CFR 0.152.
 */
package br.com.concretesolutions.requestmatcher;

import br.com.concretesolutions.requestmatcher.RequestUtils;
import br.com.concretesolutions.requestmatcher.assertion.BodyAssertion;
import br.com.concretesolutions.requestmatcher.assertion.RequestAssertion;
import br.com.concretesolutions.requestmatcher.model.Query;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import okhttp3.Headers;
import okhttp3.mockwebserver.RecordedRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

public final class RequestMatcher {
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String DELETE = "DELETE";
    public static final String PUT = "PUT";
    private Set<Query> expectedQueries;
    private Map<String, String> expectedHeaders;
    private RequestAssertion requestAssert;
    private BodyAssertion bodyAssertion;
    private String expectedPath;
    private String expectedMethod;
    private boolean expectNoBody;

    public RequestMatcher assertRequest(RequestAssertion requestAssert) {
        this.requestAssert = requestAssert;
        return this;
    }

    public RequestMatcher assertPathIs(String expectedPath) {
        this.expectedPath = expectedPath;
        return this;
    }

    public RequestMatcher assertBody(BodyAssertion bodyAssertion) {
        if (this.expectNoBody) {
            throw new IllegalArgumentException("Cannot assertBody and assertNoBody together");
        }
        this.bodyAssertion = bodyAssertion;
        return this;
    }

    public RequestMatcher assertNoBody() {
        if (this.bodyAssertion != null) {
            throw new IllegalArgumentException("Cannot assertBody and assertNoBody together");
        }
        this.expectNoBody = true;
        return this;
    }

    public RequestMatcher assertHasQuery(String key, String value) {
        if (this.expectedQueries == null) {
            this.expectedQueries = new HashSet<Query>();
        }
        this.expectedQueries.add(Query.of(key, value));
        return this;
    }

    public RequestMatcher assertHasHeader(String key, String value) {
        if (this.expectedHeaders == null) {
            this.expectedHeaders = new HashMap<String, String>();
        }
        this.expectedHeaders.put(key, value);
        return this;
    }

    public RequestMatcher assertMethodIs(String method) {
        this.expectedMethod = method;
        return this;
    }

    public void doAssert(RecordedRequest request) {
        if (this.requestAssert != null) {
            this.requestAssert.doAssert(request);
        }
        if (this.expectedMethod != null) {
            MatcherAssert.assertThat((Object)request.getMethod(), (Matcher)Matchers.is((Object)this.expectedMethod));
        }
        String path = RequestUtils.getPathOnly(request);
        if (this.expectedPath != null) {
            MatcherAssert.assertThat((Object)path, (Matcher)Matchers.is((Object)this.expectedPath));
        }
        this.queryAssertions(request.getPath());
        this.headerAssertions(request.getHeaders());
        this.bodyAssertions(request);
    }

    private void headerAssertions(Headers headers) {
        if (this.expectedHeaders == null || this.expectedHeaders.isEmpty()) {
            return;
        }
        if (headers.size() == 0) {
            Assert.fail((String)"Expected headers but found none");
        }
        Map headersMultiMap = headers.toMultimap();
        Map expectedHeadersMultiMap = Headers.of(this.expectedHeaders).toMultimap();
        for (Map.Entry entry : expectedHeadersMultiMap.entrySet()) {
            MatcherAssert.assertThat((Object)headersMultiMap, (Matcher)Matchers.hasEntry(entry.getKey(), entry.getValue()));
        }
    }

    private void queryAssertions(String path) {
        if (this.expectedQueries == null || this.expectedQueries.isEmpty()) {
            return;
        }
        if (!RequestUtils.hasQuery(path)) {
            Assert.fail((String)"Expected query strings but found none");
        }
        Set<Query> allQueries = RequestUtils.buildQueries(path);
        for (Query query : this.expectedQueries) {
            MatcherAssert.assertThat(allQueries, (Matcher)Matchers.hasItem((Object)query));
        }
    }

    private void bodyAssertions(RecordedRequest request) {
        String body = RequestUtils.getBody(request);
        if (this.expectNoBody && !"".equals(body)) {
            Assert.fail((String)"Expected no body but received one");
        }
        if (this.bodyAssertion != null) {
            if ("".equals(body)) {
                Assert.fail((String)"Expected body but found none");
            }
            this.bodyAssertion.doAssert(body);
        }
    }

    public int hashCode() {
        return super.hashCode();
    }
}

