/*
 * Decompiled with CFR 0.152.
 */
package br.com.concretesolutions.requestmatcher;

import br.com.concretesolutions.requestmatcher.IOReader;
import br.com.concretesolutions.requestmatcher.RequestAssertionError;
import br.com.concretesolutions.requestmatcher.RequestMatcher;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.QueueDispatcher;
import okhttp3.mockwebserver.RecordedRequest;
import okhttp3.mockwebserver.SocketPolicy;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class RequestMatcherRule
implements TestRule {
    private static final String ASSERT_HEADER = "REQUEST-ASSERT";
    private static final String ERROR_MESSAGE = "Failed assertion for %s";
    private final Map<String, RequestMatcher> requestAssertions = new HashMap<String, RequestMatcher>();
    private final MockWebServer server;
    private RequestAssertionError assertionError;

    public RequestMatcherRule() {
        this(new MockWebServer());
    }

    public RequestMatcherRule(MockWebServer server) {
        this.server = server;
    }

    protected abstract InputStream open(String var1) throws IOException;

    public Statement apply(Statement base, Description description) {
        return this.requestAssertionStatement(base);
    }

    public RequestMatcher enqueue(MockResponse response) {
        RequestMatcher requestMatcher = new RequestMatcher();
        String assertPath = response.hashCode() + "_::_" + requestMatcher.hashCode();
        this.server.enqueue(response.setHeader(ASSERT_HEADER, (Object)assertPath));
        this.requestAssertions.put(assertPath, requestMatcher);
        return requestMatcher;
    }

    public RequestMatcher enqueueDisconnect() {
        return this.enqueue(new MockResponse().setSocketPolicy(SocketPolicy.DISCONNECT_AT_START));
    }

    public RequestMatcher enqueueNoBody(int statusCode) {
        return this.enqueue(new MockResponse().setResponseCode(statusCode).setBody(""));
    }

    public RequestMatcher enqueue(int statusCode, String assetPath) {
        return this.enqueue(new MockResponse().setResponseCode(statusCode).setBody(this.readFixture(assetPath)));
    }

    public RequestMatcher enqueueGET(int statusCode) {
        return this.enqueueNoBody(statusCode).assertNoBody().assertMethodIs("GET");
    }

    public RequestMatcher enqueueGET(int statusCode, String assetPath) {
        return this.enqueue(statusCode, assetPath).assertNoBody().assertMethodIs("GET");
    }

    public RequestMatcher enqueuePOST(int statusCode) {
        return this.enqueueNoBody(statusCode).assertMethodIs("POST");
    }

    public RequestMatcher enqueuePOST(int statusCode, String assetPath) {
        return this.enqueue(statusCode, assetPath).assertMethodIs("POST");
    }

    public RequestMatcher enqueuePUT(int statusCode) {
        return this.enqueueNoBody(statusCode).assertMethodIs("PUT");
    }

    public RequestMatcher enqueuePUT(int statusCode, String assetPath) {
        return this.enqueue(statusCode, assetPath).assertMethodIs("PUT");
    }

    public HttpUrl url(String path) {
        return this.server.url(path);
    }

    public MockWebServer getMockWebServer() {
        return this.server;
    }

    private void before() {
        this.server.setDispatcher((Dispatcher)new QueueDispatcher(){

            public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
                MockResponse response = super.dispatch(request);
                RequestMatcher matcher = (RequestMatcher)RequestMatcherRule.this.requestAssertions.get(response.getHeaders().get(RequestMatcherRule.ASSERT_HEADER));
                if (matcher != null) {
                    try {
                        matcher.doAssert(request);
                    }
                    catch (AssertionError e) {
                        String message = String.format(RequestMatcherRule.ERROR_MESSAGE, request);
                        RequestMatcherRule.this.assertionError = new RequestAssertionError(message, (Error)((Object)e));
                        return new MockResponse().setSocketPolicy(SocketPolicy.DISCONNECT_AT_END);
                    }
                }
                return response;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void after(boolean success) {
        block7: {
            if (!success) {
                return;
            }
            int requestQueueSize = this.requestAssertions.size();
            int requestCount = this.server.getRequestCount();
            try {
                if (this.assertionError != null) {
                    throw this.assertionError;
                }
                if (requestQueueSize == requestCount) break block7;
                try {
                    Assert.fail((String)("Enqueued " + requestQueueSize + " requests but used " + requestCount + " requests."));
                }
                catch (AssertionError e) {
                    throw new RequestAssertionError("Failed assertion.", (Error)((Object)e));
                }
            }
            finally {
                this.assertionError = null;
                this.requestAssertions.clear();
            }
        }
    }

    private Statement requestAssertionStatement(final Statement base) {
        return new Statement(){

            public void evaluate() throws Throwable {
                RequestMatcherRule.this.before();
                boolean success = false;
                try {
                    base.evaluate();
                    success = true;
                }
                finally {
                    RequestMatcherRule.this.after(success);
                }
            }
        };
    }

    private String readFixture(String assetPath) {
        try {
            return IOReader.read(this.open("fixtures/" + assetPath));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read asset with path " + assetPath, e);
        }
    }
}

