/*
 * Decompiled with CFR 0.152.
 */
package br.com.concretesolutions.requestmatcher;

import android.util.Pair;
import br.com.concretesolutions.requestmatcher.RequestUtils;
import br.com.concretesolutions.requestmatcher.assertion.BodyAssertion;
import br.com.concretesolutions.requestmatcher.assertion.RequestAssertion;
import java.util.HashSet;
import java.util.Set;
import okhttp3.mockwebserver.RecordedRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

public final class RequestMatcher {
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String DELETE = "DELETE";
    public static final String PUT = "PUT";
    private final Set<Pair<String, String>> expectedQueries = new HashSet<Pair<String, String>>();
    private RequestAssertion requestAssert;
    private BodyAssertion bodyAssertion;
    private String expectedPath;
    private String expectedMethod;
    private boolean expectNoBody;

    public RequestMatcher assertRequest(RequestAssertion requestAssert) {
        this.requestAssert = requestAssert;
        return this;
    }

    public RequestMatcher assertPathIs(String expectedPath) {
        this.expectedPath = expectedPath;
        return this;
    }

    public RequestMatcher assertBody(BodyAssertion bodyAssertion) {
        if (this.expectNoBody) {
            throw new IllegalArgumentException("Cannot assertBody and assertNoBody together");
        }
        this.bodyAssertion = bodyAssertion;
        return this;
    }

    public RequestMatcher assertNoBody() {
        if (this.bodyAssertion != null) {
            throw new IllegalArgumentException("Cannot assertBody and assertNoBody together");
        }
        this.expectNoBody = true;
        return this;
    }

    public RequestMatcher assertHasQuery(String key, String value) {
        this.expectedQueries.add((Pair<String, String>)Pair.create((Object)key, (Object)value));
        return this;
    }

    public RequestMatcher assertMethodIs(String method) {
        this.expectedMethod = method;
        return this;
    }

    public void doAssert(RecordedRequest request) {
        if (this.requestAssert != null) {
            this.requestAssert.doAssert(request);
        }
        if (this.expectedMethod != null) {
            MatcherAssert.assertThat((Object)request.getMethod(), (Matcher)Matchers.is((Object)this.expectedMethod));
        }
        String path = request.getPath();
        if (this.expectedPath != null) {
            MatcherAssert.assertThat((Object)path, (Matcher)Matchers.is((Object)this.expectedPath));
        }
        this.queryAssertions(path);
        this.bodyAssertions(request);
    }

    private void queryAssertions(String path) {
        if (this.expectedQueries.isEmpty()) {
            return;
        }
        if (!RequestUtils.hasQuery(path)) {
            Assert.fail((String)"Expected query strings but found none");
        }
        Set<Pair<String, String>> allQueries = RequestUtils.buildQueries(path);
        for (Pair<String, String> query : this.expectedQueries) {
            MatcherAssert.assertThat(query, (Matcher)Matchers.isIn(allQueries));
        }
    }

    private void bodyAssertions(RecordedRequest request) {
        String body = RequestUtils.getBody(request);
        if (this.expectNoBody) {
            MatcherAssert.assertThat((Object)body, (Matcher)Matchers.isEmptyString());
        }
        if (this.bodyAssertion != null) {
            if ("".equals(body)) {
                Assert.fail((String)"Expected body but found none");
            }
            this.bodyAssertion.doAssert(body);
        }
    }

    public int hashCode() {
        return super.hashCode();
    }
}

