/*
 * Decompiled with CFR 0.152.
 */
package br.com.codecode.whateverx.model;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;

@MappedSuperclass
public abstract class BaseEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(updatable=false, nullable=false)
    private Long id = 0L;
    @XmlTransient
    @Version
    @Column
    private int version;
    @XmlTransient
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(updatable=false, nullable=false)
    private Date createdAt;
    @XmlTransient
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column
    private Date updatedAt;
    @Column(updatable=false, nullable=false)
    private String uuid;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @PrePersist
    private void prepareToPersist() {
        this.insertTimeStamp();
        this.generateUUID();
    }

    private void generateUUID() {
        this.uuid = UUID.randomUUID().toString();
    }

    private void insertTimeStamp() {
        this.createdAt = new Date();
    }

    @PreUpdate
    private void updateTimeStamp() {
        this.updatedAt = new Date();
    }

    public int getVersion() {
        return this.version;
    }

    private void setVersion(int version) {
        this.version = version;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    private void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    private void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getUuid() {
        return this.uuid;
    }

    private void setUuid(String uuid) {
        this.uuid = uuid;
    }
}

