/*
 * Decompiled with CFR 0.152.
 */
package br.com.codecode.whateverx.dao;

import br.com.codecode.whateverx.dao.Crud;
import br.com.codecode.whateverx.model.BaseEntity;
import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public class Dao<T extends BaseEntity>
implements Crud<T>,
Serializable {
    private static final long serialVersionUID = 2314421570933641745L;
    private Class<?> clazz;
    private EntityManager em;

    private Dao() {
        System.out.println("[CDI] - Dao.Dao()");
    }

    public Dao(Class<? extends BaseEntity> clazz, EntityManager em) {
        System.out.println("[CDI] - Dao.Dao(" + clazz.getSimpleName() + ")");
        System.out.println("[CDI] - EM Hash -> " + em.getClass().hashCode());
        this.clazz = clazz;
        this.em = em;
    }

    public T save(T entity) {
        this.em.persist(entity);
        System.out.println("Dao.save()");
        return entity;
    }

    public void delete(T entity) {
        this.em.remove(entity);
        System.out.println("Dao.delete()");
    }

    public T update(T entity) {
        System.out.println("Dao.update()");
        return (T)((BaseEntity)this.em.merge(entity));
    }

    public List<T> listAll() {
        TypedQuery query = this.em.createNamedQuery(this.clazz.getSimpleName() + ".findAll", this.clazz);
        return query.getResultList();
    }

    public T findById(Long id) {
        System.out.println("Dao.findById()");
        return (T)((BaseEntity)this.em.find(this.clazz, (Object)id));
    }

    public T saveOrUpdate(T entity) {
        if (entity.getId() == null || entity.getId() < 0L) {
            throw new IllegalArgumentException("Unexpected Id");
        }
        if (entity.getId() == 0L) {
            this.save(entity);
        } else {
            this.update(entity);
        }
        return entity;
    }
}

