package br.com.codecode.vlocadora.pojo.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class Devolucao implements Serializable {

	private static final long serialVersionUID = -8099844046497845423L;

	private Locacao locacao;

    private boolean devolvido;

    private Date dataRetorno;

    private String observacao;

    private float multa;

    private float totalPago;

    private boolean pago;

    public Devolucao() {
    }

    public Locacao getLocacao() {
        return locacao;
    }

    public void setLocacao(Locacao locacao) {
        this.locacao = locacao;
    }

    public boolean getDevolvido() {
        return devolvido;
    }

    public void setDevolvido(boolean devolvido) {
        this.devolvido = devolvido;
    }

    public Date getDataRetorno() {
        return dataRetorno;
    }

    public void setDataRetorno(Date dataRetorno) {
        this.dataRetorno = dataRetorno;
    }

    public String getObservacao() {
        return observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public float getMulta() {
        return multa;
    }

    public void setMulta(float multa) {
        this.multa = multa;
    }

    public float getTotalPago() {
        return totalPago;
    }

    public void setTotalPago(float totalPago) {
        this.totalPago = totalPago;
    }

    public boolean getPago() {
        return pago;
    }

    public void setPago(boolean pago) {
        this.pago = pago;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.locacao);
        hash = 29 * hash + Objects.hashCode(this.devolvido);
        hash = 29 * hash + Objects.hashCode(this.dataRetorno);
        hash = 29 * hash + Objects.hashCode(this.observacao);
        hash = 29 * hash + Objects.hashCode(this.multa);
        hash = 29 * hash + Objects.hashCode(this.totalPago);
        hash = 29 * hash + Objects.hashCode(this.pago);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Devolucao other = (Devolucao) obj;
        if (!Objects.equals(this.observacao, other.observacao)) {
            return false;
        }
        if (!Objects.equals(this.locacao, other.locacao)) {
            return false;
        }
        if (!Objects.equals(this.devolvido, other.devolvido)) {
            return false;
        }
        if (!Objects.equals(this.dataRetorno, other.dataRetorno)) {
            return false;
        }
        if (!Objects.equals(this.multa, other.multa)) {
            return false;
        }
        if (!Objects.equals(this.totalPago, other.totalPago)) {
            return false;
        }
        if (!Objects.equals(this.pago, other.pago)) {
            return false;
        }
        return true;
    }

}
