package br.com.codecode.vlocadora.pojo.model;

import java.util.List;
import java.util.Objects;

public class Cliente extends Pessoa {

	private static final long serialVersionUID = 6618716437524746014L;

	private float saldo;

    private List<Dependente> dependente;

    public Cliente() {
    }

    public float getSaldo() {
        return saldo;
    }

    public void setSaldo(float saldo) {
        this.saldo = saldo;
    }

    public List<Dependente> getDependente() {
        return dependente;
    }

    public void setDependente(List<Dependente> dependente) {
        this.dependente = dependente;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + Objects.hashCode(this.saldo);
        hash = 19 * hash + Objects.hashCode(this.dependente);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Cliente other = (Cliente) obj;
        if (!Objects.equals(this.saldo, other.saldo)) {
            return false;
        }
        if (!Objects.equals(this.dependente, other.dependente)) {
            return false;
        }
        return true;
    }

}
