package br.com.codecode.vlocadora.pojo.model;

import java.util.Objects;

public class Categoria extends Entidade {

	private static final long serialVersionUID = 9123613493481065788L;

	private String nome;

    private byte classificacao;

    public Categoria() {
    }

    public Categoria(String nome, byte classificacao) {
        this.nome = nome;
        this.classificacao = classificacao;
    }

    public String getNome() {
        return nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public byte getClassificacao() {
        return classificacao;
    }

    public void setClassificacao(byte classificacao) {
        this.classificacao = classificacao;
    }

    @Override
    public String toString() {
        return nome;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Objects.hashCode(this.nome);
        hash = 23 * hash + Objects.hashCode(this.classificacao);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Categoria other = (Categoria) obj;
        if (!Objects.equals(this.nome, other.nome)) {
            return false;
        }
        if (!Objects.equals(this.classificacao, other.classificacao)) {
            return false;
        }
        return true;
    }

}
