/*
 * Decompiled with CFR 0.152.
 */
package br.com.codecode.dryutil.factory.singleton;

import br.com.codecode.dryutil.LoadProperties;
import br.com.codecode.dryutil.factory.exception.ConnectionException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public final class JDBC {
    private static Connection connection;
    private static JDBC instance;
    private Context ctx = null;
    private String dbHost;
    private String dbLogin;
    private String dbName;
    private String dbPassword;
    private String dbPort;
    private DataSource ds = null;
    private String jndiName;
    private Properties properties;
    private String url = "jdbc:mysql://%s:%s/%s";

    private JDBC() {
        this.doLoadProperties();
        try {
            this.doLoadJNDIConnection();
            System.out.println("Connected with JNDI !");
        }
        catch (ConnectionException e) {
            System.err.println("Failed to load JNDI, trying to load Driver Manager \n " + e);
            try {
                this.doLoadDriverManager();
                System.out.println("Connected with Driver Manager !");
            }
            catch (ConnectionException ex) {
                throw new RuntimeException("Failed to load Driver Manager", ex);
            }
        }
    }

    public static synchronized JDBC getInstance() throws ConnectionException {
        if (instance == null) {
            instance = new JDBC();
        }
        return instance;
    }

    public void doCloseConnection() {
        try {
            if (!connection.isClosed()) {
                connection.close();
                System.out.println("Connection was closed");
            } else {
                System.out.println("Connection already closed");
            }
        }
        catch (SQLException ex) {
            System.err.println(ex);
        }
    }

    private void doLoadDriverManager() throws ConnectionException {
        System.out.println("[doLoadDriverManager]");
        this.url = String.format(this.url, this.dbHost, this.dbPort, this.dbName);
        try {
            connection = DriverManager.getConnection(this.url, this.dbLogin, this.dbPassword);
        }
        catch (SQLException ex) {
            throw new ConnectionException("Could not load Driver Manager, check the properties of the connection. : ", ex);
        }
    }

    private void doLoadJNDIConnection() throws ConnectionException {
        System.out.println("[doLoadJNDIConnection]");
        try {
            this.ctx = new InitialContext();
            this.ds = (DataSource)this.ctx.lookup(this.jndiName);
            connection = this.ds.getConnection();
        }
        catch (SQLException | NamingException ex) {
            throw new ConnectionException("Could not load Driver Manager, check the properties of the connection. :", ex);
        }
    }

    private void doLoadProperties() {
        try {
            this.properties = LoadProperties.readProperties(ClassLoader.class.getResourceAsStream("/META-INF/properties.properties"));
            this.dbHost = this.properties.getProperty("dbHost");
            this.dbPort = this.properties.getProperty("dbPort");
            this.dbName = this.properties.getProperty("dbName");
            this.dbLogin = this.properties.getProperty("dbLogin");
            this.dbPassword = this.properties.getProperty("dbPassword");
            this.jndiName = this.properties.getProperty("jndiName");
        }
        catch (IOException e) {
            throw new RuntimeException("File properties Not Found ", e);
        }
    }

    public Connection getConnection() {
        return connection;
    }
}

