/*
 * Decompiled with CFR 0.152.
 */
package br.com.codecode.dryutil.factory.singleton;

import br.com.codecode.dryutil.LoadProperties;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public final class EMF {
    private static EMF instance;
    private static String persistenceUnity;
    private EntityManager entityManager;
    private Properties properties;

    private EMF() {
        try {
            this.properties = LoadProperties.readProperties(new File("./src/resources/META-INF/properties.properties"));
            persistenceUnity = this.properties.getProperty("persistenceUnity");
        }
        catch (IOException e) {
            throw new RuntimeException("File properties Not Found ", e);
        }
        this.entityManager = this.getEntityManager();
    }

    public static synchronized EMF getInstance() {
        if (instance == null) {
            instance = new EMF();
        }
        return instance;
    }

    public EntityManager getEntityManager() {
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)persistenceUnity);
        if (this.entityManager == null) {
            this.entityManager = factory.createEntityManager();
        }
        return this.entityManager;
    }
}

