/*
 * Decompiled with CFR 0.152.
 */
package br.com.codecode.dryutil.factory;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public final class HTTP {
    private static final String ACCEPT_LANGUAGE = "UTF-8";
    private static final String USER_AGENT = "Mozilla/5.0";

    private HTTP() {
    }

    public static String doSend(URL url, String method, int timeout) throws RuntimeException {
        StringBuffer response;
        if (url == null || method.equals("") || timeout < 0) {
            throw new IllegalArgumentException("Missing or Incorrect Parameters !!!");
        }
        try {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod(method);
            con.setRequestProperty("User-Agent", USER_AGENT);
            con.setRequestProperty("Accept-Language", ACCEPT_LANGUAGE);
            con.setConnectTimeout(timeout);
            int responseCode = con.getResponseCode();
            System.out.println("\nSending " + method + " request to URL : " + url + "Timeout is set up to " + timeout + " mili/s");
            System.out.println("Response Code : " + responseCode);
            try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                String inputLine;
                response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create a connection ", e);
        }
        return response.toString();
    }

    public static String doSend(URL url, String parameter, String method, int timeout) throws RuntimeException {
        if (url == null || parameter.equals("") || method.equals("") || timeout < 0) {
            throw new IllegalArgumentException("Missing or Incorrect Parameters !!!");
        }
        StringBuffer response = null;
        try {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod(method);
            con.setRequestProperty("User-Agent", USER_AGENT);
            con.setRequestProperty("Accept-Language", ACCEPT_LANGUAGE);
            con.setRequestProperty("Content-Type", "application/json");
            con.setDoOutput(true);
            try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
                wr.writeBytes(parameter);
                wr.flush();
            }
            int responseCode = con.getResponseCode();
            System.out.println("\nSending " + method + " request to URL : " + url + "Timeout is set up to " + timeout + " mili/s");
            System.out.println("With parameter : " + parameter);
            System.out.println("Response Code : " + responseCode);
            try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                String inputLine;
                response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create a connection ", e);
        }
        return response.toString();
    }

    @Deprecated
    public static String sendGet(URL url) throws IOException {
        StringBuffer response;
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("User-Agent", USER_AGENT);
        con.setRequestProperty("Accept-Language", ACCEPT_LANGUAGE);
        int responseCode = con.getResponseCode();
        System.out.println("\nSending 'GET' request to URL : " + url);
        System.out.println("Response Code : " + responseCode);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
            String inputLine;
            response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
        }
        return response.toString();
    }

    @Deprecated
    public static String sendPost(URL url, String urlParameters) throws IOException {
        StringBuffer response;
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("User-Agent", USER_AGENT);
        con.setRequestProperty("Accept-Language", ACCEPT_LANGUAGE);
        con.setRequestProperty("Content-Type", "application/json");
        con.setDoOutput(true);
        try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
            wr.writeBytes(urlParameters);
            wr.flush();
        }
        int responseCode = con.getResponseCode();
        System.out.println("\nSending 'POST' request to URL : " + url);
        System.out.println("Post parameters : " + urlParameters);
        System.out.println("Response Code : " + responseCode);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
            String inputLine;
            response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
        }
        return response.toString();
    }
}

