/*
 * Decompiled with CFR 0.152.
 */
package br.com.codecode.dryutil.factory;

import br.com.codecode.dryutil.LoadProperties;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public final class EMF {
    private EntityManager entityManager;
    private String persistenceUnity;
    private Properties properties;

    public EMF() {
        try {
            this.properties = LoadProperties.readProperties(ClassLoader.class.getResourceAsStream("/META-INF/properties.properties"));
            this.persistenceUnity = this.properties.getProperty("persistenceUnity");
        }
        catch (IOException e) {
            throw new RuntimeException("File properties Not Found ", e);
        }
        this.entityManager = this.getEntityManager();
    }

    public EMF(File file) {
        try {
            this.properties = LoadProperties.readProperties(file);
            this.persistenceUnity = this.properties.getProperty("persistenceUnity");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("File properties Not Found on Specified Path ", e);
        }
        this.entityManager = this.getEntityManager();
    }

    public EntityManager getEntityManager() {
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)this.persistenceUnity);
        if (this.entityManager == null) {
            this.entityManager = factory.createEntityManager();
        }
        return this.entityManager;
    }
}

