/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.orm.aspect;

import br.com.climb.cdi.annotations.Inject;
import br.com.climb.cdi.annotations.Interceptor;
import br.com.climb.cdi.interceptor.Context;
import br.com.climb.cdi.interceptor.MethodIntercept;
import br.com.climb.core.interfaces.ClimbConnection;
import br.com.climb.orm.annotation.ImplementDaoMethod;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ImplementDaoMethod
@Interceptor
public class ImplementDaoMethodIntercept
implements MethodIntercept {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private ClimbConnection climbConnection;

    public void setClimbConnection(ClimbConnection climbConnection) {
        this.climbConnection = climbConnection;
    }

    private Class<?> getTypeInterface(String className) {
        try {
            return Class.forName(className.replace("class ", "").trim());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Type findClassParameterType(Class<?> classe) {
        Type[] genericTypes;
        Type[] typeArray;
        int n;
        int n2;
        Type genericInterface = classe.getGenericSuperclass();
        if (genericInterface instanceof ParameterizedType && (n2 = 0) < (n = (typeArray = (genericTypes = ((ParameterizedType)genericInterface).getActualTypeArguments())).length)) {
            Type genericType = typeArray[n2];
            return genericType;
        }
        return null;
    }

    @Override
    public Object interceptorMethod(Context ctx) throws Exception {
        System.out.println("****** Dao Method Intercept ******");
        try {
            Object object = null;
            if (ctx.getArgs().length > 0) {
                object = ctx.getArgs()[0];
            }
            if (ctx.getMethod().getName().equals("save")) {
                this.save(object);
            }
            if (ctx.getMethod().getName().equals("update")) {
                this.update(object);
            }
            if (ctx.getMethod().getName().equals("delete")) {
                this.delete(object);
            }
            if (ctx.getMethod().getName().equals("delete")) {
                this.delete(object);
            }
            if (ctx.getMethod().getName().equals("findOne")) {
                Type type = ImplementDaoMethodIntercept.findClassParameterType(this.getTypeInterface(ctx.getaClass().toString()));
                return this.findOne(type, (Long)object);
            }
            if (ctx.getMethod().getName().equals("find")) {
                Type type = ImplementDaoMethodIntercept.findClassParameterType(this.getTypeInterface(ctx.getaClass().toString()));
                return this.find(type);
            }
            return object;
        }
        catch (Exception e) {
            this.logger.error("ImplementDaoMethodIntercept ERROR: {}", (Throwable)e);
            return null;
        }
    }

    private Object findOne(Type type, Long id) {
        return this.climbConnection.findOne((Class)type, id);
    }

    private Object find(Type type) {
        return this.climbConnection.find((Class)type);
    }

    private void delete(Object object) {
        this.climbConnection.delete(object);
    }

    private void update(Object object) {
        this.climbConnection.update(object);
    }

    public void save(Object object) {
        this.climbConnection.save(object);
    }
}

