/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.framework.servlets;

import br.com.climb.cdi.ManagerContext;
import br.com.climb.framework.JettyServer;
import br.com.climb.framework.execptions.NotFoundException;
import br.com.climb.framework.requestresponse.HttpRequest;
import br.com.climb.framework.requestresponse.LoaderMethodRestController;
import br.com.climb.framework.requestresponse.Request;
import br.com.climb.framework.requestresponse.model.Capsule;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerServlet
extends HttpServlet {
    private static final String TEXT_PLAIN = "text/plain";
    private static final Logger logger = LoggerFactory.getLogger(ControllerServlet.class);

    private Request getLocalRequest(HttpServletRequest request) throws IOException {
        return new HttpRequest(request.getMethod(), request.getPathInfo(), request.getContentType(), request.getParameterMap(), request.getReader());
    }

    private void responseForClient(Capsule capsule, HttpServletResponse response, HttpServletRequest request) throws InvocationTargetException, IllegalAccessException {
        try (ManagerContext context = JettyServer.containerInitializer.createManager();){
            Object instance = context.generateInstance(capsule.getMethod().getDeclaringClass());
            Object result = capsule.getMethod().invoke(instance, capsule.getArgs());
            if (result != null) {
                ObjectMapper mapper = new ObjectMapper();
                String json = mapper.writeValueAsString(result);
                response.setContentType("application/json; charset=UTF-8;");
                response.setCharacterEncoding("UTF-8");
                response.setStatus(200);
                ServletOutputStream out = response.getOutputStream();
                out.write(json.getBytes());
                out.flush();
                out.close();
                context.disposeObjects();
            }
        }
        catch (Exception e) {
            logger.error("responseForClient { }", (Throwable)e);
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            AsyncContext asyncContext = request.startAsync();
            new Thread(() -> {
                HttpServletRequest req = (HttpServletRequest)asyncContext.getRequest();
                HttpServletResponse res = (HttpServletResponse)asyncContext.getResponse();
                try {
                    LoaderMethodRestController loaderMethod = new LoaderMethodRestController();
                    Capsule capsule = loaderMethod.getMethodForCall(this.getLocalRequest(req));
                    this.responseForClient(capsule, res, req);
                }
                catch (NotFoundException e) {
                    try {
                        res.setContentType(TEXT_PLAIN);
                        res.setStatus(404);
                        PrintWriter out = response.getWriter();
                        out.print(e.getMessage());
                        out.flush();
                    }
                    catch (Exception ex) {
                        logger.error("{ }", (Throwable)ex);
                    }
                    logger.error("{ }", (Throwable)e);
                }
                catch (Exception e) {
                    res.setStatus(500);
                    logger.error("{ }", (Throwable)e);
                }
                finally {
                    asyncContext.complete();
                }
            }).start();
        }
        catch (Exception e) {
            logger.error("THREAD doPut { }", (Throwable)e);
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            AsyncContext asyncContext = request.startAsync();
            new Thread(() -> {
                HttpServletRequest req = (HttpServletRequest)asyncContext.getRequest();
                HttpServletResponse res = (HttpServletResponse)asyncContext.getResponse();
                try {
                    LoaderMethodRestController loaderMethod = new LoaderMethodRestController();
                    Capsule capsule = loaderMethod.getMethodForCall(this.getLocalRequest(req));
                    this.responseForClient(capsule, res, req);
                }
                catch (NotFoundException e) {
                    try {
                        res.setContentType(TEXT_PLAIN);
                        res.setStatus(404);
                        PrintWriter out = response.getWriter();
                        out.print(e.getMessage());
                        out.flush();
                    }
                    catch (Exception ex) {
                        logger.error("message { }", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    res.setStatus(500);
                    logger.error("{ }", (Throwable)e);
                }
                finally {
                    asyncContext.complete();
                }
            }).start();
        }
        catch (Exception e) {
            logger.error("THREAD doDelete { }", (Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            AsyncContext asyncContext = request.startAsync();
            new Thread(() -> {
                HttpServletRequest req = (HttpServletRequest)asyncContext.getRequest();
                HttpServletResponse res = (HttpServletResponse)asyncContext.getResponse();
                try {
                    LoaderMethodRestController loaderMethod = new LoaderMethodRestController();
                    Capsule capsule = loaderMethod.getMethodForCall(this.getLocalRequest(req));
                    this.responseForClient(capsule, res, req);
                }
                catch (NotFoundException e) {
                    try {
                        res.setContentType(TEXT_PLAIN);
                        res.setStatus(404);
                        PrintWriter out = response.getWriter();
                        out.print(e.getMessage());
                        out.flush();
                    }
                    catch (Exception ex) {
                        logger.error("{ }", (Throwable)ex);
                    }
                    logger.error("{ }", (Throwable)e);
                }
                catch (Exception e) {
                    res.setStatus(500);
                    logger.error("{ }", (Throwable)e);
                }
                finally {
                    asyncContext.complete();
                }
            }).start();
        }
        catch (Exception e) {
            logger.error("THREAD doPost { }", (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            AsyncContext asyncContext = request.startAsync();
            new Thread(() -> {
                HttpServletRequest req = (HttpServletRequest)asyncContext.getRequest();
                HttpServletResponse res = (HttpServletResponse)asyncContext.getResponse();
                try {
                    if (req.getPathInfo().equals("/favicon.ico")) {
                        return;
                    }
                    LoaderMethodRestController loaderMethod = new LoaderMethodRestController();
                    Capsule capsule = loaderMethod.getMethodForCall(this.getLocalRequest(req));
                    this.responseForClient(capsule, res, req);
                }
                catch (NotFoundException e) {
                    res.setContentType(TEXT_PLAIN);
                    res.setStatus(404);
                    PrintWriter out = null;
                    try {
                        out = response.getWriter();
                    }
                    catch (IOException ioException) {
                        logger.error("{ }", (Throwable)ioException);
                    }
                    out.print(e.getMessage());
                    out.flush();
                    logger.error("{ }", (Throwable)e);
                }
                catch (Exception e) {
                    res.setContentType(TEXT_PLAIN);
                    res.setStatus(404);
                    PrintWriter out = null;
                    try {
                        out = response.getWriter();
                    }
                    catch (IOException ioException) {
                        logger.error("{ }", (Throwable)ioException);
                    }
                    out.println("***** ERROR ****** ");
                    out.println(e.toString());
                    out.flush();
                    logger.error("{ }", (Throwable)e);
                }
                finally {
                    asyncContext.complete();
                }
            }).start();
        }
        catch (Exception e) {
            logger.error("THREAD DoGet { }", (Throwable)e);
        }
    }
}

