/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.framework.requestresponse;

import br.com.climb.framework.annotations.param.RequestBody;
import br.com.climb.framework.annotations.param.RequestParam;
import br.com.climb.framework.execptions.NotFoundException;
import br.com.climb.framework.requestresponse.Methods;
import br.com.climb.framework.requestresponse.Request;
import br.com.climb.framework.requestresponse.interfaces.LoaderMethod;
import br.com.climb.framework.requestresponse.model.Capsule;
import br.com.climb.framework.utils.ReflectionUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

public class LoaderMethodRestController
implements LoaderMethod {
    protected Object[] getCastValuesRequestMapping(Method method, List<String> values) {
        Class<?>[] types = method.getParameterTypes();
        Object[] params = values.toArray();
        for (int i = 0; i < types.length; ++i) {
            if ("class java.lang.String".equals(types[i].toString())) {
                params[i] = values.get(i);
                continue;
            }
            if ("class java.lang.Integer".equals(types[i].toString())) {
                params[i] = new Integer(values.get(i));
                continue;
            }
            if ("class java.lang.Long".equals(types[i].toString())) {
                params[i] = new Long(values.get(i));
                continue;
            }
            if ("class java.lang.Float".equals(types[i].toString())) {
                params[i] = new Float(values.get(i));
                continue;
            }
            if ("class java.lang.Double".equals(types[i].toString())) {
                params[i] = new Double(values.get(i));
                continue;
            }
            if (!"class java.lang.Boolean".equals(types[i].toString())) continue;
            params[i] = new Boolean(values.get(i));
        }
        return params;
    }

    protected Object[] getBodyRequest(Method method, Request request, Object[] arguments) throws IOException {
        ArrayList<Object> arg = new ArrayList<Object>(Arrays.asList(arguments));
        String body = request.getReader().lines().collect(Collectors.joining());
        if (body != null && body.trim().length() > 0 && request.getContentType().equals("application/json")) {
            Parameter[] parameters;
            for (Parameter parameter : parameters = method.getParameters()) {
                RequestBody requestBody = parameter.getAnnotation(RequestBody.class);
                if (requestBody == null) continue;
                ObjectMapper mapper = new ObjectMapper();
                Object result = mapper.readValue(body, parameter.getType());
                arg.add(result);
                break;
            }
        }
        return arg.toArray();
    }

    protected String getNormalizedUrl(Request request) {
        String[] arrUrl = request.getPathInfo().split("/");
        StringBuilder builder = new StringBuilder();
        builder.append("/");
        LongStream.range(1L, arrUrl.length).forEach(index -> {
            String word = arrUrl[(int)index].trim();
            if (Methods.isReservedWord(word, index)) {
                builder.append(word + "/");
            } else if (ReflectionUtils.isNumeric(word)) {
                builder.append("class java.lang.Number/");
            } else if (word.equals("true") || word.equals("false")) {
                builder.append("class java.lang.Boolean/");
            } else {
                builder.append("class java.lang.String/");
            }
        });
        return builder.toString();
    }

    protected Object[] extractValueUrlRequestMapping(Request request, Method method) {
        List<String> values = this.extractValueUrl(request);
        return this.getCastValuesRequestMapping(method, values);
    }

    protected Object[] extractValueUrlRequestParam(Request request, Method method) {
        ArrayList valuesRequestParam = new ArrayList();
        Arrays.asList(method.getParameters()).forEach(param -> {
            RequestParam requestParam = param.getAnnotation(RequestParam.class);
            request.getParameterMap().forEach((k, v) -> {
                if (requestParam != null && requestParam.value().equals(k)) {
                    String value = String.join((CharSequence)" ", Arrays.asList(v)).trim();
                    if (param.getType() == String.class) {
                        valuesRequestParam.add(value);
                    }
                    if (param.getType() == Integer.class || param.getType() == Integer.TYPE) {
                        valuesRequestParam.add(new Integer(value));
                    }
                    if (param.getType() == Long.class || param.getType() == Long.TYPE) {
                        valuesRequestParam.add(new Long(value));
                    }
                    if (param.getType() == Float.class || param.getType() == Float.TYPE) {
                        valuesRequestParam.add(new Float(value));
                    }
                    if (param.getType() == Double.class || param.getType() == Double.TYPE) {
                        valuesRequestParam.add(new Double(value));
                    }
                    if (param.getType() == Boolean.class || param.getType() == Boolean.TYPE) {
                        valuesRequestParam.add(new Boolean(value));
                    }
                }
            });
        });
        return valuesRequestParam.toArray();
    }

    protected List<String> extractValueUrl(Request request) {
        String[] splitUrl = request.getPathInfo().split("/");
        ArrayList<String> values = new ArrayList<String>();
        IntStream.range(1, splitUrl.length).forEach(index -> {
            String word = splitUrl[index].trim();
            if (!Methods.isReservedWord(word, Long.valueOf(index))) {
                values.add(word);
            }
        });
        return values;
    }

    @Override
    public Capsule getMethodForCall(Request request) throws NotFoundException, IOException {
        String url = this.getNormalizedUrl(request);
        Method method = null;
        if (request.getMethod().equals("GET")) {
            method = Methods.GET.get(url);
        }
        if (request.getMethod().equals("POST")) {
            method = Methods.POST.get(url);
        }
        if (request.getMethod().equals("PUT")) {
            method = Methods.PUT.get(url);
        }
        if (request.getMethod().equals("DELETE")) {
            method = Methods.DELETE.get(url);
        }
        if (method == null) {
            throw new NotFoundException("method not found for url : " + request.getPathInfo());
        }
        Object[] args = this.extractValueUrlRequestParam(request, method);
        if (args.length == 0) {
            args = this.extractValueUrlRequestMapping(request, method);
        }
        return new Capsule(method, this.getBodyRequest(method, request, args));
    }
}

