/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.framework.requestresponse;

import br.com.climb.framework.annotations.RequestMapping;
import br.com.climb.framework.annotations.mapping.DeleteMapping;
import br.com.climb.framework.annotations.mapping.GetMapping;
import br.com.climb.framework.annotations.mapping.PostMapping;
import br.com.climb.framework.annotations.mapping.PutMapping;
import br.com.climb.framework.annotations.param.PathVariable;
import br.com.climb.framework.requestresponse.Methods;
import br.com.climb.framework.requestresponse.interfaces.Storage;
import br.com.climb.framework.utils.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class LoaderClassRestController
implements Storage {
    @Override
    public void storage(Set<Class<?>> clazzs) {
        clazzs.parallelStream().forEach(clazz -> {
            RequestMapping requestMapping = clazz.getAnnotation(RequestMapping.class);
            Arrays.stream(clazz.getMethods()).forEach(method -> {
                GetMapping getMapping = method.getAnnotation(GetMapping.class);
                PostMapping postMapping = method.getAnnotation(PostMapping.class);
                PutMapping putMapping = method.getAnnotation(PutMapping.class);
                DeleteMapping deleteMapping = method.getAnnotation(DeleteMapping.class);
                if (getMapping != null) {
                    System.out.println("GET: " + requestMapping.value() + getMapping.value());
                    if (requestMapping != null) {
                        this.storageGetMethod(requestMapping, (Method)method);
                    } else {
                        this.storageGetMethod((Method)method);
                    }
                }
                if (postMapping != null) {
                    System.out.println("POST: " + requestMapping.value() + postMapping.value());
                    if (requestMapping != null) {
                        this.storagePostMethod(requestMapping, (Method)method);
                    } else {
                        this.storagePostMethod((Method)method);
                    }
                }
                if (putMapping != null) {
                    System.out.println("PUT: " + requestMapping.value() + putMapping.value());
                    if (requestMapping != null) {
                        this.storagePutMethod(requestMapping, (Method)method);
                    } else {
                        this.storagePutMethod((Method)method);
                    }
                }
                if (deleteMapping != null) {
                    System.out.println("DELETE: " + requestMapping.value() + deleteMapping.value());
                    if (requestMapping != null) {
                        this.storageDeleteMethod(requestMapping, (Method)method);
                    } else {
                        this.storageDeleteMethod((Method)method);
                    }
                }
            });
        });
    }

    protected void storageGetMethod(RequestMapping requestMapping, Method method) {
        GetMapping getMapping = method.getAnnotation(GetMapping.class);
        String value = requestMapping.value() + getMapping.value();
        this.storageGet(value, method);
    }

    protected void storageGetMethod(Method method) {
        GetMapping getMapping = method.getAnnotation(GetMapping.class);
        String value = getMapping.value();
        this.storageGet(value, method);
    }

    protected void storagePostMethod(RequestMapping requestMapping, Method method) {
        PostMapping getMapping = method.getAnnotation(PostMapping.class);
        String value = requestMapping.value() + getMapping.value();
        this.storagePost(value, method);
    }

    protected void storagePostMethod(Method method) {
        PostMapping getMapping = method.getAnnotation(PostMapping.class);
        String value = getMapping.value();
        this.storagePost(value, method);
    }

    protected void storagePutMethod(RequestMapping requestMapping, Method method) {
        PutMapping getMapping = method.getAnnotation(PutMapping.class);
        String value = requestMapping.value() + getMapping.value();
        this.storagePut(value, method);
    }

    protected void storagePutMethod(Method method) {
        PutMapping getMapping = method.getAnnotation(PutMapping.class);
        String value = getMapping.value();
        this.storagePut(value, method);
    }

    protected void storageDeleteMethod(RequestMapping requestMapping, Method method) {
        DeleteMapping getMapping = method.getAnnotation(DeleteMapping.class);
        String value = requestMapping.value() + getMapping.value();
        this.storageDelete(value, method);
    }

    protected void storageDeleteMethod(Method method) {
        DeleteMapping getMapping = method.getAnnotation(DeleteMapping.class);
        String value = getMapping.value();
        this.storageDelete(value, method);
    }

    private void storageGet(String value, Method method) {
        value = this.getNormalizedUrl(value, method);
        Methods.GET.put(value, method);
        this.generateReservedWords(value);
    }

    private void storagePost(String value, Method method) {
        value = this.getNormalizedUrl(value, method);
        Methods.POST.put(value, method);
        this.generateReservedWords(value);
    }

    private void storagePut(String value, Method method) {
        value = this.getNormalizedUrl(value, method);
        Methods.PUT.put(value, method);
        this.generateReservedWords(value);
    }

    private void storageDelete(String value, Method method) {
        value = this.getNormalizedUrl(value, method);
        Methods.DELETE.put(value, method);
        this.generateReservedWords(value);
    }

    private String getNormalizedUrl(String value, Method method) {
        Parameter[] parameters;
        for (Parameter parameter : parameters = method.getParameters()) {
            PathVariable pathVariable = parameter.getAnnotation(PathVariable.class);
            if (pathVariable == null) continue;
            value = value.replace("{" + pathVariable.value() + "}", ReflectionUtils.getTypeClimbString(parameter.getType()));
        }
        return value;
    }

    private void generateReservedWords(String value) {
        String[] splitedArray = value.split("/");
        for (long i = 1L; i < (long)splitedArray.length; ++i) {
            String word = splitedArray[(int)i];
            if (ReflectionUtils.isJavaType(word)) continue;
            Set<Long> position = Methods.RESERVED_WORDS.get(word);
            if (position == null) {
                position = new HashSet<Long>();
                Methods.RESERVED_WORDS.put(word, position);
            }
            position.add(i);
        }
    }
}

