/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.framework.servlets.filters;

import br.com.climb.framework.utils.JwtUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.SignatureException;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(JwtFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse res = (HttpServletResponse)servletResponse;
        String token = req.getHeader("Authentication");
        if (token == null || token.trim().isEmpty()) {
            res.setStatus(401);
            return;
        }
        try {
            Jws<Claims> parser = JwtUtil.decode(token);
            logger.info("User request: {}", (Object)((Claims)parser.getBody()).getSubject());
            filterChain.doFilter(servletRequest, servletResponse);
        }
        catch (SignatureException e) {
            res.setStatus(401);
        }
    }

    public void destroy() {
    }
}

