/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.cdi.teste.model.factory;

import br.com.climb.cdi.annotations.Component;
import br.com.climb.cdi.annotations.Factory;
import br.com.climb.cdi.annotations.Inject;
import br.com.climb.cdi.annotations.Produces;
import br.com.climb.cdi.model.Capsule;
import br.com.climb.framework.utils.ReflectionUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;

public class ClimbCdiContainer {
    private static final Map<Class, List<Class>> concreteInterfaceClasses = new HashMap<Class, List<Class>>();
    private static final Map<Class, Capsule> factoriesClasses = new HashMap<Class, Capsule>();

    protected static Class getQualifierClass(Field field) {
        List<Class> listConcreteClassInterface = concreteInterfaceClasses.get(field.getType());
        if (listConcreteClassInterface != null && listConcreteClassInterface.size() > 1) {
            String qualifier = field.getAnnotation(Inject.class).value();
            List listClazzTemp = listConcreteClassInterface.stream().filter(aClass -> aClass.getAnnotation(Component.class).value().equals(qualifier)).collect(Collectors.toList());
            return (Class)listClazzTemp.get(0);
        }
        return concreteInterfaceClasses.get(field.getType()).get(0);
    }

    protected static Class getClassOfField(Field field) {
        if (field.getType().isInterface()) {
            return ClimbCdiContainer.getQualifierClass(field);
        }
        return field.getType();
    }

    protected static Object generateInstanceByTheFactory(Field field) {
        Capsule capsule = factoriesClasses.get(field.getType());
        if (capsule == null) {
            return null;
        }
        try {
            Object instance = capsule.getClassFactory().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ClimbCdiContainer.injectObjectInFields(capsule.getClassFactory(), instance);
            return capsule.getMethod().invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        throw new Error("unexpected error in this operation");
    }

    protected static Object generateInstance(Field field) {
        Object localInstance = ClimbCdiContainer.generateInstanceByTheFactory(field);
        if (localInstance != null) {
            return localInstance;
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(ClimbCdiContainer.getClassOfField(field));
        enhancer.setCallback((Callback)((MethodInterceptor)(obj, method, args, proxy) -> {
            if (method.getName().contains("get")) {
                Class<?> returnType = method.getReturnType();
                Object result = proxy.invokeSuper(obj, args);
                if (result == null && returnType.getAnnotation(Component.class) != null) {
                    return ClimbCdiContainer.generateInstanceBase(method.getReturnType());
                }
                return result;
            }
            return proxy.invokeSuper(obj, args);
        }));
        return enhancer.create();
    }

    protected static void injectInstanceField(Object main, Field field, Object instance) {
        String methodName = "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        try {
            Method method = main.getClass().getMethod(methodName, field.getType());
            method.invoke(main, instance);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void injectObjectInFields(Class clazz, Object instance) {
        Arrays.asList(clazz.getDeclaredFields()).parallelStream().filter(field -> field.getAnnotation(Inject.class) != null).forEach(field -> ClimbCdiContainer.injectInstanceField(instance, field, ClimbCdiContainer.generateInstance(field)));
    }

    public static synchronized Object generateInstanceBase(Class clazz) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setCallback((Callback)((MethodInterceptor)(obj, method, args, proxy) -> proxy.invokeSuper(obj, args)));
        Object base = enhancer.create();
        ClimbCdiContainer.injectObjectInFields(clazz, base);
        return base;
    }

    private static void startFactories() throws IOException {
        Arrays.asList(ReflectionUtils.getAnnotedClass(Factory.class, "br.com.")).parallelStream().forEach(classes -> classes.stream().forEach(factoryClass -> Arrays.asList(factoryClass.getMethods()).stream().forEach(method -> {
            if (method.getAnnotation(Produces.class) != null) {
                Capsule capsule = new Capsule();
                capsule.setClassFactory((Class)factoryClass);
                capsule.setMethod((Method)method);
                factoriesClasses.put(method.getReturnType(), capsule);
            }
        })));
    }

    public static void start() throws IOException {
        ClimbCdiContainer.startFactories();
        Arrays.asList(ReflectionUtils.getAnnotedClass(Component.class, "br.com.")).parallelStream().forEach(classes -> classes.stream().forEach(aClass -> Arrays.asList(aClass.getInterfaces()).parallelStream().forEach(iface -> {
            List<Class> clazzs = concreteInterfaceClasses.get(iface);
            if (clazzs == null) {
                clazzs = new ArrayList<Class>();
                clazzs.add((Class)aClass);
                concreteInterfaceClasses.put((Class)iface, clazzs);
            } else {
                clazzs.add((Class)aClass);
            }
        })));
    }
}

