/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.cdi.instances;

import br.com.climb.cdi.Initializer;
import br.com.climb.cdi.annotations.Inject;
import br.com.climb.cdi.clazz.TypeOfClass;
import br.com.climb.cdi.disposes.Disposes;
import br.com.climb.cdi.instances.InjectInstance;
import br.com.climb.cdi.instances.Instances;
import br.com.climb.cdi.instances.Singleton;
import br.com.climb.cdi.interceptor.InterceptorMethod;
import br.com.climb.cdi.model.Capsule;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;

public class InstancesManager
implements Instances,
InjectInstance,
Singleton {
    private Initializer initializer;
    private Disposes disposes;
    private TypeOfClass typeOfClass;
    private Map<Class<?>, Object> singletonsObjects = new HashMap();

    private InstancesManager(Initializer initializer, Disposes disposes, TypeOfClass typeOfClass) {
        this.initializer = initializer;
        this.disposes = disposes;
        this.typeOfClass = typeOfClass;
    }

    public static Instances create(Initializer initializer, Disposes disposes, TypeOfClass typeOfClass) {
        return new InstancesManager(initializer, disposes, typeOfClass);
    }

    @Override
    public Object generateInstanceByTheFactory(Field field) {
        Capsule capsule = this.initializer.getFactoriesClasses().get(field.getType());
        if (capsule == null) {
            return null;
        }
        try {
            Object singletonInstance = this.getSingletonObject(capsule);
            if (singletonInstance != null) {
                return singletonInstance;
            }
            Object instance = capsule.getClassFactory().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.injectObjecstInComponentClass(capsule.getClassFactory(), instance);
            Object resultInvoke = capsule.getMethod().invoke(instance, new Object[0]);
            this.disposes.addDisposeList(capsule, resultInvoke);
            return resultInvoke;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        throw new Error("unexpected error in this operation");
    }

    @Override
    public Object generateInstance(Field field) {
        Object localInstance = this.generateInstanceByTheFactory(field);
        if (localInstance != null) {
            return localInstance;
        }
        Enhancer enhancer = new Enhancer();
        System.out.println(this.typeOfClass);
        enhancer.setSuperclass(this.typeOfClass.getClassOfField(field));
        enhancer.setCallback((Callback)new InterceptorMethod(this.typeOfClass, this));
        return enhancer.create();
    }

    @Override
    public Object generateInstanceBase(Class<?> clazz) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setCallback((Callback)((MethodInterceptor)(obj, method, args, proxy) -> proxy.invokeSuper(obj, args)));
        Object base = enhancer.create();
        this.injectObjecstInComponentClass(clazz, base);
        return base;
    }

    @Override
    public void injectObjecstInComponentClass(Class<?> clazz, Object instance) {
        Arrays.asList(clazz.getDeclaredFields()).stream().filter(field -> field.getAnnotation(Inject.class) != null).forEach(field -> this.injectInstanceField(instance, (Field)field, this.generateInstance((Field)field)));
    }

    @Override
    public void injectInstanceField(Object main, Field field, Object instance) {
        String methodName = "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        try {
            Method method = main.getClass().getMethod(methodName, field.getType());
            method.invoke(main, instance);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object getSingletonObject(Capsule capsule) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, InstantiationException {
        if (capsule.getMethod().getAnnotation(br.com.climb.cdi.annotations.Singleton.class) != null) {
            Object singleton = this.singletonsObjects.get(capsule.getMethod().getReturnType());
            if (singleton != null) {
                return singleton;
            }
            Object instance = capsule.getClassFactory().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.injectObjecstInComponentClass(capsule.getClassFactory(), instance);
            Object resultInvoke = capsule.getMethod().invoke(instance, new Object[0]);
            this.singletonsObjects.put(capsule.getMethod().getReturnType(), resultInvoke);
            this.disposes.addDisposeList(capsule, resultInvoke);
            return resultInvoke;
        }
        return null;
    }
}

