/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.cdi.disposes;

import br.com.climb.cdi.Initializer;
import br.com.climb.cdi.disposes.Disposes;
import br.com.climb.cdi.model.Capsule;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DisposesManager
implements Disposes {
    private Initializer initializer;
    private Set<Object> disposesObjects = new HashSet<Object>();

    private DisposesManager(Initializer initializer) {
        this.initializer = initializer;
    }

    public static Disposes create(Initializer initializer) {
        return new DisposesManager(initializer);
    }

    @Override
    public boolean isDisposes(Class clazz) {
        Capsule result = this.initializer.getDisposesMethods().get(clazz);
        if (result != null) {
            return true;
        }
        List classes = Arrays.asList(clazz.getInterfaces()).stream().filter(aClass -> this.initializer.getDisposesMethods().get(aClass) != null).collect(Collectors.toList());
        if (classes.size() > 0) {
            return true;
        }
        List ifaces = Arrays.asList(clazz.getSuperclass().getGenericInterfaces()).stream().filter(aClass -> this.initializer.getDisposesMethods().get(aClass) != null).collect(Collectors.toList());
        return ifaces.size() > 0;
    }

    @Override
    public void disposeObjects() {
        this.disposesObjects.stream().forEach(object -> {
            List ifaces;
            Capsule capsule = this.initializer.getDisposesMethods().get(object.getClass());
            if (capsule == null && (ifaces = Arrays.asList(object.getClass().getSuperclass().getGenericInterfaces()).stream().filter(aClass -> this.initializer.getDisposesMethods().get(aClass) != null).collect(Collectors.toList())).size() > 0) {
                capsule = this.initializer.getDisposesMethods().get(ifaces.get(0));
            }
            try {
                Object instance = capsule.getClassFactory().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                capsule.getMethod().invoke(instance, object);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void addDisposeList(Capsule capsule, Object resultInvoke) {
        if (this.isDisposes(resultInvoke.getClass())) {
            this.disposesObjects.add(resultInvoke);
        }
    }
}

