/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.cdi;

import br.com.climb.cdi.Container;
import br.com.climb.cdi.Initializer;
import br.com.climb.cdi.ManagerContext;
import br.com.climb.cdi.annotations.Component;
import br.com.climb.cdi.annotations.Disposes;
import br.com.climb.cdi.annotations.Factory;
import br.com.climb.cdi.annotations.Interceptor;
import br.com.climb.cdi.annotations.Produces;
import br.com.climb.cdi.model.Capsule;
import br.com.climb.framework.utils.ReflectionUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class ContainerInitializer
implements Initializer {
    protected final Map<Class<?>, List<Class<?>>> concreteInterfaceClasses = new HashMap();
    protected final Map<Class<?>, Capsule> factoriesClasses = new HashMap();
    protected final Map<Class<?>, Class<?>> interceptorClasses = new HashMap();
    protected final Map<Class<?>, Capsule> disposesMethods = new HashMap();

    @Override
    public Map<Class<?>, Capsule> getDisposesMethods() {
        return this.disposesMethods;
    }

    @Override
    public Map<Class<?>, Capsule> getFactoriesClasses() {
        return this.factoriesClasses;
    }

    @Override
    public Map<Class<?>, List<Class<?>>> getConcreteInterfaceClasses() {
        return this.concreteInterfaceClasses;
    }

    @Override
    public Map<Class<?>, Class<?>> getInterceptorClasses() {
        return this.interceptorClasses;
    }

    public static ContainerInitializer newInstance() {
        return new Container();
    }

    protected void startInterceptors() throws IOException {
        Arrays.asList(ReflectionUtils.getAnnotedClass(Interceptor.class, "br.com.")).parallelStream().forEach(classes -> classes.stream().forEach(interceptorClass -> {
            List annotationType = Arrays.asList(interceptorClass.getAnnotations()).stream().filter(annotation -> annotation.annotationType() != Interceptor.class).map(annotation -> annotation.annotationType()).collect(Collectors.toList());
            this.interceptorClasses.put((Class<?>)annotationType.get(0), (Class<?>)interceptorClass);
        }));
    }

    protected void startDisposesClass() throws IOException {
        Arrays.asList(ReflectionUtils.getAnnotedClass(Factory.class, "br.com.")).parallelStream().forEach(classes -> classes.stream().forEach(factoryClass -> Arrays.asList(factoryClass.getMethods()).stream().forEach(method -> {
            if (method.getAnnotation(Disposes.class) != null) {
                Capsule capsule = new Capsule();
                capsule.setClassFactory((Class)factoryClass);
                capsule.setMethod((Method)method);
                if (method.getParameters().length > 0) {
                    Parameter parameter = Arrays.asList(method.getParameters()).get(0);
                    this.disposesMethods.put(parameter.getType(), capsule);
                } else {
                    try {
                        throw new IOException("the method with the annotation dispose needs an argument");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        })));
    }

    protected void startFactories() throws IOException {
        Arrays.asList(ReflectionUtils.getAnnotedClass(Factory.class, "br.com.")).parallelStream().forEach(classes -> classes.stream().forEach(factoryClass -> Arrays.asList(factoryClass.getMethods()).stream().forEach(method -> {
            if (method.getAnnotation(Produces.class) != null) {
                Capsule capsule = new Capsule();
                capsule.setClassFactory((Class)factoryClass);
                capsule.setMethod((Method)method);
                this.factoriesClasses.put(method.getReturnType(), capsule);
            }
        })));
    }

    protected void initialiseConcreteInterfaceClasses() throws IOException {
        Arrays.asList(ReflectionUtils.getAnnotedClass(Component.class, "br.com.")).parallelStream().forEach(classes -> classes.stream().forEach(aClass -> Arrays.asList(aClass.getInterfaces()).parallelStream().forEach(iface -> {
            List<Class<?>> clazzs = this.concreteInterfaceClasses.get(iface);
            if (clazzs == null) {
                clazzs = new ArrayList();
                clazzs.add((Class<?>)aClass);
                this.concreteInterfaceClasses.put((Class<?>)iface, clazzs);
            } else {
                clazzs.add((Class<?>)aClass);
            }
        })));
    }

    public abstract ManagerContext createManager();
}

