/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.framework;

import br.com.climb.framework.annotations.RestController;
import br.com.climb.framework.requestresponse.LoaderClassRestController;
import br.com.climb.framework.servlets.ControllerServlet;
import br.com.climb.framework.servlets.filters.CorsFilter;
import br.com.climb.framework.servlets.filters.JwtFilter;
import br.com.climb.framework.utils.ReflectionUtils;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer {
    private static final Logger logger = LoggerFactory.getLogger(JettyServer.class);

    public void start() throws Exception {
        Server server = new Server(8080);
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        servletContextHandler.setContextPath("/");
        servletContextHandler.addServlet(ControllerServlet.class, "/*");
        servletContextHandler.addEventListener((EventListener)((Object)new MyContextListener()));
        servletContextHandler.addFilter(JwtFilter.class, "/api/*", EnumSet.of(DispatcherType.REQUEST));
        servletContextHandler.addFilter(CorsFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)servletContextHandler);
        Set<Class<?>> clazzs = ReflectionUtils.getAnnotedClass(RestController.class, "br.com.");
        LoaderClassRestController storage = new LoaderClassRestController();
        storage.storage(clazzs);
        System.out.println("***** INICIOU O SERVIDOR *****");
        server.setHandler((Handler)handlers);
        server.start();
    }

    public static void main(String[] args) throws Exception {
        new JettyServer().start();
    }

    public static class MyRequestListener
    implements ServletRequestListener {
        public void requestDestroyed(ServletRequestEvent sre) {
            System.err.printf("MyRequestListener.requestDestroyed(%s)%n", sre);
        }

        public void requestInitialized(ServletRequestEvent sre) {
            System.err.printf("MyRequestListener.requestInitialized(%s)%n", sre);
        }
    }

    public static class MyContextListener
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            System.err.printf("MyContextListener.contextInitialized(%s)%n", sce);
            sce.getServletContext().addListener((EventListener)((Object)new MyRequestListener()));
        }

        public void contextDestroyed(ServletContextEvent sce) {
            System.err.printf("MyContextListener.contextDestroyed(%s)%n", sce);
        }
    }
}

