package br.com.climb.commons.model.rpc;

import br.com.climb.commons.model.Message;

import java.util.Objects;

public class RpcResponse implements Message {

    private final String uuid;
    private final Integer statusCode;
    private final String typeMessage;
    private final Object response;

    public RpcResponse(String uuid, Integer statusCode, String typeMessage, Object response) {
        this.statusCode = statusCode;
        this.typeMessage = typeMessage;
        this.response = response;
        this.uuid = uuid;
    }

    public String getUuid() {
        return uuid;
    }

    public Integer getStatusCode() {
        return statusCode;
    }

    public Object getResponse() {
        return response;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RpcResponse response = (RpcResponse) o;
        return Objects.equals(uuid, response.uuid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uuid);
    }

    @Override
    public String toString() {
        return "RpcResponse{" +
                "uuid='" + uuid + '\'' +
                ", statusCode=" + statusCode +
                ", response=" + response +
                '}';
    }

    @Override
    public String getTypeOfMessage() {
        return typeMessage;
    }
}
