package br.com.climb.commons.model.rpc;

import br.com.climb.commons.model.Message;

import java.util.Arrays;
import java.util.Objects;

public class RpcRequest implements Message {

    private final String uuid;
    private final String methodName;
    private final String typeMessage;
    private final Object[] args;

    public RpcRequest(String uuid, String methodName, String typeMessage, Object[] args) {
        this.uuid = uuid;
        this.methodName = methodName;
        this.typeMessage = typeMessage;
        this.args = args;
    }

    public String getUuid() {
        return uuid;
    }

    public Object[] getArgs() {
        return args;
    }

    public String getMethodName() {
        return methodName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RpcRequest request = (RpcRequest) o;
        return Objects.equals(uuid, request.uuid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uuid);
    }

    @Override
    public String getTypeOfMessage() {
        return typeMessage;
    }

    @Override
    public String toString() {
        return "RpcRequest{" +
                "uuid='" + uuid + '\'' +
                ", methodName='" + methodName + '\'' +
                ", args=" + Arrays.toString(args) +
                '}';
    }


}
