package br.com.climb.commons.model;

import java.util.List;

public class ReceiveMessage implements Message {

    private final String topicName;
    private final String typeMessage;
    private final List<SendMessage> messages;

    public ReceiveMessage(String topicName, String typeMessage, List<SendMessage> messages) {
        this.topicName = topicName;
        this.typeMessage = typeMessage;
        this.messages = messages;
    }

    public String getTopicName() {
        return topicName;
    }

    public List<SendMessage> getMessages() {
        return messages;
    }

    @Override
    public String getTypeOfMessage() {
        return typeMessage;
    }

    @Override
    public String toString() {
        return "ReceiveMessage{" +
                "topicName='" + topicName + '\'' +
                ", messages=" + messages +
                '}';
    }

}
