/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.commons.generictcpclient;

import br.com.climb.commons.generictcpclient.GenericTcpClientHandler;
import br.com.climb.commons.generictcpclient.TcpClient;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public abstract class GenericTcpClient<T>
implements TcpClient<T> {
    private static final int TIMEOUT = 1000;
    private final GenericTcpClientHandler clientHandler;
    private final String hostname;
    private final int port;
    private NioSocketConnector connector;
    private IoSession session;

    public GenericTcpClient(GenericTcpClientHandler clientHandler, String hostname, int port) {
        this.clientHandler = clientHandler;
        this.hostname = hostname;
        this.port = port;
        this.initialize();
    }

    private void initialize() {
        this.createConnector();
        this.startConnection();
    }

    private void createConnector() {
        this.connector = new NioSocketConnector();
        this.connector.setConnectTimeoutMillis(1000L);
        this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
        this.connector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        this.connector.setHandler((IoHandler)this.clientHandler);
    }

    private void startConnection() {
        ConnectFuture future = this.connector.connect((SocketAddress)new InetSocketAddress(this.hostname, this.port));
        future.awaitUninterruptibly();
        this.session = future.getSession();
    }

    @Override
    public Object getResponse() {
        return this.clientHandler.getResponse();
    }

    @Override
    public void sendRequest(T request) {
        this.session.write(request);
    }

    @Override
    public void closeConnection() {
        if (this.session != null && this.session.isConnected()) {
            this.session.closeOnFlush().awaitUninterruptibly();
        }
        this.connector.dispose();
    }
}

