/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.commons.url;

import br.com.climb.commons.annotations.param.PathVariable;
import br.com.climb.commons.reqrespmodel.Request;
import br.com.climb.commons.url.Methods;
import br.com.climb.commons.url.NormalizedUrl;
import br.com.climb.commons.utils.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.stream.LongStream;

public class NormalizedUrlManager
implements NormalizedUrl {
    @Override
    public String getNormalizedUrl(String value, Method method) {
        Parameter[] parameters;
        for (Parameter parameter : parameters = method.getParameters()) {
            PathVariable pathVariable = parameter.getAnnotation(PathVariable.class);
            if (pathVariable == null) continue;
            value = value.replace("{" + pathVariable.value() + "}", ReflectionUtils.getTypeClimbString(parameter.getType()));
        }
        return value;
    }

    @Override
    public String getNormalizedUrl(Request request) {
        String[] arrUrl = request.getPathInfo().split("/");
        StringBuilder builder = new StringBuilder();
        builder.append("/");
        LongStream.range(1L, arrUrl.length).forEach(index -> {
            String word = arrUrl[(int)index].trim();
            if (Methods.isReservedWord(word, index)) {
                builder.append(word + "/");
            } else if (ReflectionUtils.isNumeric(word)) {
                builder.append("class java.lang.Number/");
            } else if (word.equals("true") || word.equals("false")) {
                builder.append("class java.lang.Boolean/");
            } else {
                builder.append("class java.lang.String/");
            }
        });
        return builder.toString();
    }
}

